<?php

namespace Marcolin\Models;

use DB;
use Illuminate\Database\Eloquent\Model;


class AutocatCatalogStyle extends WebModel
{
    protected $table = "AutocatCatalogStyles";
    protected $fillable = [
        'autocatcatalog_id',
        'style_id',
        'default_status',
        'override_status',
        'order',
    ];

    public function autocatCatalog()
    {
        return $this->belongsTo(AutocatCatalog::class, 'autocatcatalog_id', 'id');
    }

    public function autocatCatalogUnits()
    {
        return $this->hasMany(AutocatCatalogUnit::class, 'autocatcatalogstyle_id', 'id');
    }

    public function autocatCatalogUnitsInCatalog()
    {
        return $this->hasMany(AutocatCatalogUnit::class, 'autocatcatalogstyle_id', 'id')
            ->whereRaw('(override_status = 1 OR (override_status IS NULL AND default_status = 1))');
    }

    public function style(){
        return$this->belongsTo(Style::class, 'style_id', 'id');
    }

    public function autocatCatalogStyleModifiers()
    {
        return $this->hasMany(AutocatCatalogStyleModifier::class, 'autocatcatalogstyle_id', 'id');
    }

    public function comments()
    {
        return $this->belongsToMany(AutocatCatalogComment::class, 'AutocatCatalogStyle_AutocatCatalogComment', 'autocatcatalogstyle_id', 'comment_id')->wherePivot('deleted_at', '=', '0000-00-00 00:00:00');
    }

    public function getIsNewAttribute() {
        $is_new_modifier = $this->autocatCatalogStyleModifiers->where('modifier_type', 'is_new')->first();
        $is_new = isset($is_new_modifier) ? $is_new_modifier->modifier_value : 0;
        return $is_new;
    }

    public function getDefaultIsRxableAttribute() {
        return $this->style->units->first()->rxAble && $this->style->productType == 'S';
    }

    public function getIsRxableAttribute() {
        $is_rxable_modifier = $this->autocatCatalogStyleModifiers->where('modifier_type', 'is_rxable')->first();
        $is_rxable = isset($is_rxable_modifier) ? $is_rxable_modifier->modifier_value : $this->default_is_rxable;
        return $is_rxable;
    }

    public function getPageBreakAfterAttribute() {
        $page_break_after_modifier = $this->autocatCatalogStyleModifiers->where('modifier_type', 'page_break_after')->first();
        $page_break_after = isset($page_break_after_modifier) ? $page_break_after_modifier->modifier_value : 0;
        return $page_break_after;
    }

    public function getHasBeenEditedAttribute() {
        return $this->is_new == 1
            || $this->is_rxable != $this->default_is_rxable
            || $this->page_break_after == 1
            || count($this->comments) > 0
            ;
    }

    public function getFirstWebUnitWithPictureAttribute()
    {
        foreach ($this->autocatCatalogUnits as $autocatCatalogUnit) {
            if ($autocatCatalogUnit->unit->webUnit->hasPrimaryImage()) {
                return $autocatCatalogUnit->unit->webUnit;
            } else {
                continue;
            }
        }
    }

    public function visibleUnits()
    {
        return $this->autocatCatalogUnits()->visible();
    }

    public function getInCatalogAttribute() {
        return $this->override_status === 1 || ($this->override_status === null && $this->default_status === 1);
    }
}
