@if($edit)
    <div class="mceNonEditable component-container" data-component-key="rebate">
        <a href="#" class="btn btn-danger pull-right delete-component">X</a>
        <h4>User Rebates</h4>
    </div>
@endif

@if($script)
    <script type="text/javascript">
        registerComponent('rebate', {
            menuText: 'User Rebates',
            bladeTemplate: 'marcolin::components.rebate',
            init: function (body) {
            },
            serialize: function (componentNode) {
                return {};
            },
        });
    </script>
@endif

@if($view)
    @if(isset(b2b()->activeCustomer()->parentCustomerRebateInformation))
        <div class="text-center">
            <h3>My Marcolin Rebates</h3>
        </div>

        <div class="row container center-block" style="display: -webkit-box; display: -webkit-flex; display: -ms-flexbox; display: flex; flex-wrap: wrap;">
            {{--Free Shipping--}}
            <div class="rebate-box @if(b2b()->activeCustomer()->parentCustomerRebateInformation->is_vision_source) col-md-4 @else col-md-6 @endif">
                <div class="panel panel-default @if(b2b()->activeCustomer()->parentCustomerRebateInformation->is_free_shipping_sales_valid && b2b()->activeCustomer()->parentCustomerRebateInformation->is_return_rate_valid) rebate-panel-qualified @else rebate-panel-unqualified @endif">
                    <div class="panel-body text-center">
                        <div style="font-size: x-large; font-weight: bolder; padding: 10px 0px;">
                            Free Shipping
                        </div>
                        @if(b2b()->activeCustomer()->parentCustomerRebateInformation->is_free_shipping_sales_valid && b2b()->activeCustomer()->parentCustomerRebateInformation->is_return_rate_valid)
                            <div style="font-weight: bolder; color: blue;">
                                Qualified!
                            </div>
                        @else
                            <div>
                                Requirements to qualify.
                            </div>
                        @endif
                        <div class="@if(b2b()->activeCustomer()->parentCustomerRebateInformation->is_free_shipping_sales_valid) rebate-requirement-qualified @else rebate-requirement-unqualified @endif">
                            <div style="font-weight: bolder;">
                                More than @if(b2b()->activeCustomer()->parentCustomerRebateInformation->is_vision_source) $5,000 @else $6,000 @endif
                            </div>
                            <div>
                                annual purchases
                            </div>
                            <div style="height: 50px;">
                                @if(b2b()->activeCustomer()->parentCustomerRebateInformation->is_free_shipping_sales_valid)
                                    <span class="glyphicon glyphicon-ok" aria-hidden="true" style="font-size: 50px; color: green;"></span>
                                @else
                                    <span class="glyphicon glyphicon-remove" aria-hidden="true" style="font-size: 50px; color: darkred;"></span>
                                @endif
                            </div>
                            <div>
                                Yearly Sales*: ${{ number_format(b2b()->activeCustomer()->parentCustomerRebateInformation->YTD) }}
                            </div>
                            <div style="padding-top: 10px;">
                                @if(!b2b()->activeCustomer()->parentCustomerRebateInformation->is_free_shipping_sales_valid)
                                    Spend ${{number_format(b2b()->activeCustomer()->parentCustomerRebateInformation->sales_amount_needed_to_get_free_freight) }} to qualify.
                                @else
                                    This criteria has been met.
                                @endif
                            </div>
                        </div>
                        <div class="@if(b2b()->activeCustomer()->parentCustomerRebateInformation->is_return_rate_valid) rebate-requirement-qualified @else rebate-requirement-unqualified @endif">
                            <div style="font-weight: bolder;">
                                Return Rate under 20%
                            </div>
                            <div style="height: 50px;">
                                @if(b2b()->activeCustomer()->parentCustomerRebateInformation->is_return_rate_valid)
                                    <span class="glyphicon glyphicon-ok" aria-hidden="true" style="font-size: 50px; color: green;"></span>
                                @else
                                    <span class="glyphicon glyphicon-remove" aria-hidden="true" style="font-size: 50px; color: darkred;"></span>
                                @endif
                            </div>
                            <div>
                                Return Rate: {{ b2b()->activeCustomer()->parentCustomerRebateInformation->YTD_RR }}%
                            </div>
                            @if(!b2b()->activeCustomer()->parentCustomerRebateInformation->is_return_rate_valid)
                                <div style="padding-top: 10px;">
                                    Spend ${{ number_format(b2b()->activeCustomer()->parentCustomerRebateInformation->required_to_get_return_rate_below_cutoff) }} to get below {{ b2b()->activeWebSilo()->required_rebate_return_percent }}%
                                </div>
                            @else
                                <div style="padding-top: 10px;">
                                    This criteria has been met.
                                </div>
                            @endif
                        </div>
                    </div>
                </div>
            </div>

            {{--4% Rebate--}}
            <div class="rebate-box @if(b2b()->activeCustomer()->parentCustomerRebateInformation->is_vision_source) col-md-4 @else col-md-6 @endif">
                <div class="panel panel-default @if(b2b()->activeCustomer()->parentCustomerRebateInformation->is_rebate_sales_valid && b2b()->activeCustomer()->parentCustomerRebateInformation->is_return_rate_valid) rebate-panel-qualified @else rebate-panel-unqualified @endif">
                    <div class="panel-body text-center">
                        <div style="font-size: x-large; font-weight: bolder; padding: 10px 0px;">
                            @if(b2b()->activeCustomer()->parentCustomerRebateInformation->is_vision_source) 5% @else 4% @endif Annual Rebate<sup>&#8224;</sup>
                        </div>
                        @if(b2b()->activeCustomer()->parentCustomerRebateInformation->is_rebate_sales_valid && b2b()->activeCustomer()->parentCustomerRebateInformation->is_return_rate_valid)
                            <div style="font-weight: bolder; color: blue;">
                                Qualified!
                            </div>
                        @else
                            <div>
                                Requirements to qualify.
                            </div>
                        @endif
                        <div class="@if(b2b()->activeCustomer()->parentCustomerRebateInformation->is_rebate_sales_valid) rebate-requirement-qualified @else rebate-requirement-unqualified @endif">
                            <div style="font-weight: bolder;">
                                More than $20,000
                            </div>

                            <div>
                                annual purchases
                            </div>

                            <div style="height: 50px;">
                                @if(b2b()->activeCustomer()->parentCustomerRebateInformation->is_rebate_sales_valid)
                                    <span class="glyphicon glyphicon-ok" aria-hidden="true" style="font-size: 50px; color: green;"></span>
                                @else
                                    <span class="glyphicon glyphicon-remove" aria-hidden="true" style="font-size: 50px; color: darkred;"></span>
                                @endif
                            </div>

                            <div>
                                Yearly Sales*: ${{ number_format(b2b()->activeCustomer()->parentCustomerRebateInformation->YTD) }}
                            </div>

                            <div style="padding-top: 10px;">
                                @if(!b2b()->activeCustomer()->parentCustomerRebateInformation->is_rebate_sales_valid)
                                    Spend ${{number_format(b2b()->activeCustomer()->parentCustomerRebateInformation->sales_ammount_needed_to_get_rebate) }} to qualify.
                                @else
                                    This criteria has been met.
                                @endif
                            </div>
                        </div>

                        <div class="@if(b2b()->activeCustomer()->parentCustomerRebateInformation->is_return_rate_valid) rebate-requirement-qualified @else rebate-requirement-unqualified @endif">
                            <div style="font-weight: bolder;">
                                Return Rate under 20%
                            </div>

                            <div style="height: 50px;">
                                @if(b2b()->activeCustomer()->parentCustomerRebateInformation->is_return_rate_valid)
                                    <span class="glyphicon glyphicon-ok" aria-hidden="true" style="font-size: 50px; color: green;"></span>
                                @else
                                    <span class="glyphicon glyphicon-remove" aria-hidden="true" style="font-size: 50px; color: darkred;"></span>
                                @endif
                            </div>

                            <div>
                                Return Rate: {{ b2b()->activeCustomer()->parentCustomerRebateInformation->YTD_RR }}%
                            </div>

                            @if(!b2b()->activeCustomer()->parentCustomerRebateInformation->is_return_rate_valid)
                                <div style="padding-top: 10px;">
                                    Spend ${{ number_format(b2b()->activeCustomer()->parentCustomerRebateInformation->required_to_get_return_rate_below_cutoff) }} to get below {{ b2b()->activeWebSilo()->required_rebate_return_percent }}%
                                </div>
                            @else
                                <div style="padding-top: 10px;">
                                    This criteria has been met.
                                </div>
                            @endif
                        </div>
                    </div>
                </div>
            </div>

            @if(b2b()->activeCustomer()->parentCustomerRebateInformation->is_vision_source)
            {{--Vision Source Growth Reward--}}
            <div class="rebate-box col-md-4">
                <div class="panel panel-default @if(b2b()->activeCustomer()->parentCustomerRebateInformation->is_vision_source_sales_valid && b2b()->activeCustomer()->parentCustomerRebateInformation->is_growth_amount_valid && b2b()->activeCustomer()->parentCustomerRebateInformation->is_return_rate_valid) rebate-panel-qualified @else rebate-panel-unqualified @endif">
                    <div class="panel-body text-center">
                        <div style="font-size: x-large; font-weight: bolder; padding: 10px 0px;">
                            5% Growth Rebate
                        </div>
                        @if(b2b()->activeCustomer()->parentCustomerRebateInformation->is_vision_source_sales_valid && b2b()->activeCustomer()->parentCustomerRebateInformation->is_growth_amount_valid && b2b()->activeCustomer()->parentCustomerRebateInformation->is_return_rate_valid)
                            <div style="font-weight: bolder; color: blue;">
                                Qualified!
                            </div>
                        @else
                            <div>
                                Requirements to qualify.
                            </div>
                        @endif
                        <div class="@if(b2b()->activeCustomer()->parentCustomerRebateInformation->is_vision_source_sales_valid) rebate-requirement-qualified @else rebate-requirement-unqualified @endif">
                            <div style="font-weight: bolder;">
                                Annual Purchase Requirements
                            </div>

                            <div class="row">
                                <div class="col-md-6">
                                    <div style="height: 40px;">
                                        @if(b2b()->activeCustomer()->parentCustomerRebateInformation->is_vision_source_this_year_sales_valid)
                                            <span class="glyphicon glyphicon-ok" aria-hidden="true" style="font-size: 40px; color: green;"></span>
                                        @else
                                            <span class="glyphicon glyphicon-remove" aria-hidden="true" style="font-size: 40px; color: darkred;"></span>
                                        @endif
                                    </div>
                                    <div>
                                    </div>
                                    This Year Sales*:
                                    <div>
                                        ${{ number_format(b2b()->activeCustomer()->parentCustomerRebateInformation->YTD) }}
                                    </div>
                                    <div style="padding-top: 10px;">
                                        Need $5,000
                                    </div>
                                </div>
                                <div class="col-md-6">
                                    <div style="height: 40px;">
                                        @if(b2b()->activeCustomer()->parentCustomerRebateInformation->is_vision_source_last_year_sales_valid)
                                            <span class="glyphicon glyphicon-ok" aria-hidden="true" style="font-size: 40px; color: green;"></span>
                                        @else
                                            <span class="glyphicon glyphicon-remove" aria-hidden="true" style="font-size: 40px; color: darkred;"></span>
                                        @endif
                                    </div>
                                    <div>
                                    </div>
                                    Last Year Sales*:
                                    <div>
                                        ${{ number_format(b2b()->activeCustomer()->parentCustomerRebateInformation->LYTD) }}
                                    </div>
                                    <div style="padding-top: 10px;">
                                        Need $1,000
                                    </div>
                                </div>
                            </div>
                        </div>

                        <div class="@if(b2b()->activeCustomer()->parentCustomerRebateInformation->is_return_rate_valid) rebate-requirement-qualified @else rebate-requirement-unqualified @endif">
                            <div style="font-weight: bolder;">
                                Return Rate under 20%
                            </div>

                            <div style="height: 50px;">
                                @if(b2b()->activeCustomer()->parentCustomerRebateInformation->is_return_rate_valid)
                                    <span class="glyphicon glyphicon-ok" aria-hidden="true" style="font-size: 50px; color: green;"></span>
                                @else
                                    <span class="glyphicon glyphicon-remove" aria-hidden="true" style="font-size: 50px; color: darkred;"></span>
                                @endif
                            </div>

                            <div>
                                Return Rate: {{ b2b()->activeCustomer()->parentCustomerRebateInformation->YTD_RR }}%
                            </div>

                            @if(!b2b()->activeCustomer()->parentCustomerRebateInformation->is_return_rate_valid)
                                <div style="padding-top: 10px;">
                                    Spend ${{ number_format(b2b()->activeCustomer()->parentCustomerRebateInformation->required_to_get_return_rate_below_cutoff) }} to get below {{ b2b()->activeWebSilo()->required_rebate_return_percent }}%
                                </div>
                            @else
                                <div style="padding-top: 10px;">
                                    This criteria has been met.
                                </div>
                            @endif
                        </div>

                        <div class="@if(b2b()->activeCustomer()->parentCustomerRebateInformation->is_growth_amount_valid) rebate-requirement-qualified @else rebate-requirement-unqualified @endif">
                            <div style="font-weight: bolder;">
                                Sales Growth
                            </div>
                            <div>
                                compared to last year to date.
                            </div>

                            <div style="height: 50px;">
                                @if(b2b()->activeCustomer()->parentCustomerRebateInformation->is_growth_amount_valid)
                                    <span class="glyphicon glyphicon-ok" aria-hidden="true" style="font-size: 50px; color: green;"></span>
                                @else
                                    <span class="glyphicon glyphicon-remove" aria-hidden="true" style="font-size: 50px; color: darkred;"></span>
                                @endif
                            </div>

                            <div>
                                Sales YTD*: ${{ number_format(b2b()->activeCustomer()->parentCustomerRebateInformation->YTD) }}
                            </div>

                            <div>
                                Sales Last YTD: ${{ number_format(b2b()->activeCustomer()->parentCustomerRebateInformation->LYTD) }}
                            </div>

                            <div style="padding-top: 10px;">
                                @if(!b2b()->activeCustomer()->parentCustomerRebateInformation->is_growth_amount_valid)
                                    Spend ${{number_format((b2b()->activeCustomer()->parentCustomerRebateInformation->LYTD + 1) - b2b()->activeCustomer()->parentCustomerRebateInformation->YTD) }} to qualify.
                                @else
                                    This criteria has been met.
                                @endif
                            </div>
                        </div>
                    </div>
                </div>
            </div>
            @endif

            <div class="col-md-12 text-right" style="font-size: smaller;">
                (Updated on: {{ Carbon\Carbon::parse(\Marcolin\Models\CustomerRebateInformation::orderBy('date_modified', 'desc')->first()->date_modified)->timezone('America/New_York')->format('m/d/Y') }})
            </div>
            <div class="col-md-12" style="font-size: smaller;">
                * Eligible purchases exclude any purchases made at discount above the standard commercial policy. Contact your sales representatives for more details, and actual amounts accrued for the year.
            </div>
            <div class="col-md-12" style="font-size: smaller; padding-bottom: 15px;">
                &#8224; All criteria must be met at the end of the year to qualify.
            </div>
        </div>

        <style>
            div.rebate-box {
                display: flex;
                flex-direction: column;
                font-size: larger;
            }

            div.rebate-panel-qualified {
                height: 100%;
                border: 4px solid green;
                box-shadow: 4px 8px #777777;
            }

            div.rebate-panel-unqualified {
                height: 100%;
                border: 4px solid darkred;
                background-color: #F0F0F0;
            }

            div.rebate-requirement-qualified {
                border: 1px groove;
                margin-top: 10px;
                padding: 10px;
                background-color: #d0ffd0;
            }

            div.rebate-requirement-unqualified {
                border: 1px groove;
                margin-top: 10px;
                padding: 10px;
                background-color: #ffd0d0;
                opacity: 0.5; filter: alpha(opacity = 50);
            }

            .grayout {
                opacity: 0.6; /* Real browsers */
                filter: alpha(opacity = 60); /* MSIE */
            }
        </style>
    @endif
@endif