<?php

namespace Marcolin\Models;

use DB;


class AutocatCatalogComment extends UuidModel
{
    use HasCommitSequence;

    protected $table = "AutocatCatalogComments";
    protected $fillable = [
        'comment_text',
        'comment_color',
    ];

    public function items()
    {
        return $this->belongsToMany(AutocatCatalogItem::class, 'AutocatCatalogItem_AutocatCatalogComment', 'comment_id', 'item_id')->wherePivot('deleted_at', '=', '0000-00-00 00:00:00');
    }
}
