<?php

namespace Marcolin\Models;

use Debugbar;
use Illuminate\Database\Eloquent\Builder;
use Illuminate\Database\Eloquent\Relations\BelongsToMany;
use Illuminate\Support\Collection;
use Illuminate\Support\Facades\DB;
use Venturecraft\Revisionable\RevisionableTrait;

class WebContactBlock extends WebModel {
	protected $table = "WebContactBlocks";
    protected $fillable = [
        'websilo_id',
        'language',
        'contact_block',
    ];

	public function webSilo() {
		return $this->belongsTo(WebSilo::class, 'websilo_id', 'id');
	}

    public function scopeWebSilo($query, $webSilo) {
	    $webSiloId = array_get($webSilo, 'id', $webSilo);

	    return $query->where('websilo_id', '=', $webSiloId);
    }
}
