<?php

namespace Marcolin\Models;


use Illuminate\Database\Eloquent\Collection;


class VirtualRepStyleList extends WebModel
{
    protected $table = "VirtualRepStyleLists";
    protected $fillable = [
        'stylelist_name',
        'stylelist_description',
        'createdby_webuser_id',
        'lasteditedby_webuser_id',
    ];

    function createdByUser()
    {
        return $this->belongsTo(WebUser::class, 'createdby_webuser_id', 'id');
    }

    function lastEditedByUser()
    {
        return $this->belongsTo(WebUser::class, 'lasteditedby_webuser_id', 'id');
    }
}
