<?php

namespace Marcolin\Models;

use DB;


class CustomerRebateInformation extends WebModel {
    protected $table = "CustomerRebateInformation";
    protected $fillable = [
        'customerCode', 'customerCode_id', 'custName', 'customerGroup09',
        'salesDistrict', 'districtManager',
        'street', 'city', 'state', 'zip', 'phone',
        'LYEQ_TOT', 'YTD', 'LYTD', 'variationYTD', 'YTD_RR', 'qualifiedPurchasesYTD', 'rebateBasedOnYTDVolume',
        'required_to_get_return_rate_below_cutoff', 'rebateAmount',
        'commit_sequence'
    ];

    public function customers() {
        return $this->hasMany(Customer::class, 'customerCode_id', 'customerCode_id');
    }

    public function getIsFreeShippingSalesValidAttribute() {
        return $this->sales_amount_needed_to_get_free_freight <= 0;
    }

    public function getIsRebateSalesValidAttribute() {
        return $this->sales_ammount_needed_to_get_rebate <= 0;
    }

    public function getIsVisionSourceSalesValidAttribute() {
        return $this->YTD > 5000;
    }

    public function getIsGrowthAmountValidAttribute() {
        return $this->growth_amount > 0;
    }

    public function getIsReturnRateValidAttribute() {
        return $this->required_to_get_return_rate_below_cutoff <= 0;
    }
}
