<?php

namespace Marcolin\Models;

use DB;
use Illuminate\Database\Eloquent\Model;


/**
 * Marcolin\Models\FOB
 *
 * @property integer $id
 * @property string $fob_code
 * @property string $fob_desc
 * @property string $date_created
 * @property string $date_modified
 * @property string $date_uploaded
 * @property string $deleted_at
 * @method static \Illuminate\Database\Query\Builder|\Marcolin\Models\FOB whereId($value)
 * @method static \Illuminate\Database\Query\Builder|\Marcolin\Models\FOB whereFobCode($value)
 * @method static \Illuminate\Database\Query\Builder|\Marcolin\Models\FOB whereFobDesc($value)
 * @method static \Illuminate\Database\Query\Builder|\Marcolin\Models\FOB whereDateCreated($value)
 * @method static \Illuminate\Database\Query\Builder|\Marcolin\Models\FOB whereDateModified($value)
 * @method static \Illuminate\Database\Query\Builder|\Marcolin\Models\FOB whereDateUploaded($value)
 * @method static \Illuminate\Database\Query\Builder|\Marcolin\Models\FOB whereDeletedAt($value)
 * @mixin \Eloquent
 */
class Style extends Model
{
    protected $table = "Styles";

    function brand()
    {
        return $this->belongsTo(Brand::class);
    }

    function productDescription()
    {
        return $this->hasMany(ProductDescription::class, "style", "style");
    }

    function units()
    {
        return $this->hasMany(Unit::class);
    }

    function visibleUnits()
    {
        return $this->hasMany(Unit::class)->webVisible();
    }

    public function productShape()
    {
        return $this->belongsTo(ProductShape::class, 'productShape_id', 'id');
    }

    public function productFitting()
    {
        return $this->belongsTo(ProductFitting::class, 'productFitting_id', 'id');
    }

    public function productRimType()
    {
        return $this->belongsTo(ProductRimType::class, 'productRimType_id', 'id');
    }

    public function productGender()
    {
        return $this->belongsTo(ProductGender::class, 'productGender_id', 'id');
    }

    // There is a field productType that is conflciting wtih this. I added a new relation called productTypeObj.
    public function productType()
    {
        return $this->belongsTo(ProductType::class, 'productType_id', 'id');
    }

    // Adding this function because there is already a field called productType that causes the function about this to fail.
    public function productTypeObj()
    {
        return $this->belongsTo(ProductType::class, 'productType_id', 'id');
    }

    public function webStyle()
    {
        return $this->hasOne(WebStyle::class);
    }

    public function getUnitsByColorAttribute()
    {
        return $this
            ->visibleUnits
            ->sortBy('color')
            ->groupBy('color')
            ->map(function ($item, $key) {
                return $item->first();
            })->values();
    }

    public function getUnitsBySizeAttribute()
    {
        return $this
            ->visibleUnits
            ->sortBy('size')
            ->groupBy('size')
            ->map(function ($item, $key) {
                return $item->first();
            })->values();
    }

    public function getOrderableAttribute($customer = false)
    {
        return $this->brand->orderable;
    }

    public function getDetailAttribute()
    {
        $productDescription = $this->productDescription;
        if (isset($productDescription) && count($productDescription) > 0) {
            $styleName = $productDescription->first()->productDesc;
            if (strlen($styleName) > 0) {
                return $styleName;
            }
        }
        return '';
    }

    public function getNameAttribute()
    {
        $productDescription = $this->productDescription;
        if (isset($productDescription) && count($productDescription) > 0) {
            $styleName = $productDescription->first()->styleName;
            if (strlen($styleName) > 0) {
                return title_case($productDescription->first()->styleName);
            }
        }
        return $this->style;
    }

    public function getDisplayNameAttribute()
    {
        $productDescription = $this->productDescription;
        if (isset($productDescription) && count($productDescription) > 0) {
            $styleName = $productDescription->first()->styleName;
            if (strlen($styleName) > 0) {
                return $this->style . ' ' . title_case($productDescription->first()->styleName);
            }
        }
        return $this->style;
    }

    public function getProductTypeDescriptionAttribute()
    {
        $productType = $this->productType;
        if (isset($productType)) {
            return $productType->productTypeDescription;
        } else {
            return null;
        }
    }

    public function getProductShapeDescriptionAttribute()
    {
        $productShape = $this->productShape;
        if (isset($productShape)) {
            return $productShape->shape;
        } else {
            return null;
        }
    }

    public function getProductRimTypeDescriptionAttribute()
    {
        $productRimType = $this->productRimType;
        if (isset($productRimType)) {
            return $productRimType->rimType;
        } else {
            return null;
        }
    }

    public function getProductFittingDescriptionAttribute()
    {
        $productFitting = $this->productFitting;
        if (isset($productFitting)) {
            return $productFitting->fitting;
        } else {
            return null;
        }
    }

    public function getProductGenderDescriptionAttribute()
    {
        $productGender = $this->productGender;
        if (isset($productGender)) {
            return $productGender->genderDescription;
        } else {
            return null;
        }
    }

    public function getCustomerPrice($customer)
    {
        $unit = $this->units->first();
        if (isset($unit)) {
            return $unit->getCustomerPrice($customer);
        } else {
            return null;
        }
    }

    public function getIsWebVisibleAttribute()
    {
        return static::webVisible()->where('id', '=', $this->id)->count() > 0;
    }

    public function getIsWebVisibleAllAttribute()
    {
        return static::webVisibleAll()->where('id', '=', $this->id)->count() > 0;
    }

    public function getIsWebVisibleAutocatAttribute()
    {
        return static::webVisibleAutocat()->where('id', '=', $this->id)->count() > 0;
    }

    public function getIsWebVisibleStandardAttribute()
    {
        return static::webVisibleStandard()->where('id', '=', $this->id)->count() > 0;
    }

    public function getIsWebVisibleHarleyDavidsonAttribute()
    {
        return static::webVisibleHarleyDavidson()->where('id', '=', $this->id)->count() > 0;
    }

    public function getIsWebVisibleTomFordLimitedAttribute()
    {
        return static::webVisibleTomFordLimited()->where('id', '=', $this->id)->count() > 0;
    }

    public function scopeWebVisible($query)
    {
        $query
            ->whereHas('units', function ($query) {
                return $query->webVisible();
            });
        return $query;
    }

    public function scopeWebVisibleAll($query)
    {
        $query
            ->whereHas('units', function ($query) {
                return $query->webVisibleAll();
            });
        return $query;
    }

    public function scopeWebVisibleAutocat($query)
    {
        $query
            ->whereHas('units', function ($query) {
                return $query->webVisibleAutocat();
            });
        return $query;
    }

    public function scopeWebVisibleStandard($query)
    {
        $query
            ->whereHas('units', function ($query) {
                return $query->webVisibleStandard();
            });
        return $query;
    }

    public function scopeWebVisibleHarleyDavidson($query)
    {
        $query
            ->whereHas('units', function ($query) {
                return $query->webVisibleHarleyDavidson();
            });
        return $query;
    }

    public function scopeWebVisibleTomFordLimited($query)
    {
        $query
            ->whereHas('units', function ($query) {
                return $query->webVisibleTomFordLimited();
            });
        return $query;
    }

    public function getFirstWebUnitWithPictureAttribute()
    {
        foreach ($this->unitsByColor as $unit) {
            if ($unit->webUnit->hasPrimaryImage()) {
                return $unit->webUnit;
            } else {
                continue;
            }
        }
    }
}
