<?php

namespace Marcolin\Models;

/**
 * Class PromotionRedemption
 * @package Marcolin\Models
 */
class PromotionRedemption extends UuidModel {
    protected $table = 'PromotionRedemptions';
    protected  $fillable = ['promotion_id', 'salesorder_id', 'customer_id', 'webuser_id', 'code', 'coupon'];

    // Relationships
    public function promotion() {
    return $this->belongsTo(WebPromotion::class, 'promotion_id', 'id');
}

    public function salesOrder() {
    return $this->belongsTo(SalesOrder::class, 'salesorder_id', 'id');
}

    public function customer() {
    return $this->belongsTo(Customer::class, 'customer_id', 'id');
}

    public function webUser() {
    return $this->belongsTo(Webuser::class, 'webuser_id', 'id');
}


    public static function hasRedeemed(WebPromotion $promotion, Customer $customer) {
    $promotionRedemption = self::promotionCustomer($promotion->id, $customer->id)->first();
    return isset($promotionRedemption);
}

    // Scopes
    public function scopePromotionCustomer($query, $promotion_id, $customer_id) {
    return
        $query
            ->where('promotion_id', $promotion_id)
            ->where('customer_id', $customer_id)
        ;
}

    public function scopeByPromotion($query, $promotion_id) {
    return $query->where('promotion_id', $promotion_id);
}

}