<?php

namespace Marcolin\Models;

/**
 * Class PromotionItemDiscountAction
 * @package Marcolin\Models
 */
class PromotionItemDiscountAction extends PromotionActionDetails {
    protected $table = 'PromotionItemDiscountActions';
    protected $fillable = ['is_percent', 'discount_amount', 'target_all_products'];
    protected $casts = ['is_percent' => 'boolean', 'target_all_products' => 'boolean'];

    // Overrides Model::boot(), used to define a specific 'deleted' state
    public static function boot() {
        parent::boot();
        // make sure all related rows in PromotionItemDiscountAction_Product are also deleted
        static::deleted(function (PromotionItemDiscountAction $promotionItemDiscountAction) {
            $promotionItemDiscountActionProducts =
                PromotionItemDiscountAction_Product::where('promotionitemdiscountaction_id', '=', $promotionItemDiscountAction->id);
            foreach ($promotionItemDiscountActionProducts as $promotionItemDiscountActionProduct) {
                $promotionItemDiscountActionProduct->delete();
            }
        });
    }

    /**
     * @param Customer $soldToCustomer
     * @param $webCartItems
     * @param $status
     * @return mixed|void
     */
    public function takeAction(Customer $soldToCustomer, $webCartItems, &$status) {}

    /**
     * Get all WebBrands specifically targeted by this action
     * @return mixed
     */
    public function brands() {
        return $this
            ->morphedByMany(Brand::class, 'product',
                'PromotionItemDiscountAction_Product', 'promotionitemdiscountaction_id')
            ->where('PromotionItemDiscountAction_Product.deleted_at', '=', '0000-00-00 00:00:00')
            ;
    }

    /**
     * Get all WebStyles specifically targeted by this action
     * @return mixed
     */
    public function styles() {
        return $this
            ->morphedByMany(Style::class, 'product',
                'PromotionItemDiscountAction_Product', 'promotionitemdiscountaction_id')
            ->where('PromotionItemDiscountAction_Product.deleted_at', '=', '0000-00-00 00:00:00')
            ;
    }

    /**
     * Get all WebUnits specifically targeted by this action
     * @return mixed
     */
    public function units() {
        return $this
            ->morphedByMany(Unit::class, 'product',
                'PromotionItemDiscountAction_Product', 'promotionitemdiscountaction_id')
            ->where('PromotionItemDiscountAction_Product.deleted_at', '=', '0000-00-00 00:00:00')
            ;
    }
}
