<?php

namespace Marcolin\Models;

use Illuminate\Database\Eloquent\Builder;

/**
 * Class Promotion
 * @package Hilco\Models
 *
 * @method static Builder active()
 */
class PromotionCurrentOrderValueTrigger extends PromotionTriggerDetails
{
    protected $table = 'PromotionCurrentOrderValueTriggers';
    protected $fillable = ['minimum_value', 'via_web', 'via_cst'];

    public function brands()
    {
        return $this
            ->morphedByMany(Brand::class, 'product', 'PromotionCurrentOrderValueTrigger_Product', 'PromotionCurrentOrderValueTrigger_id')
            ->withPivot(['excluded']);
    }

    public function styles()
    {
        return $this
            ->morphedByMany(Style::class, 'product', 'PromotionCurrentOrderValueTrigger_Product', 'PromotionCurrentOrderValueTrigger_id')
            ->withPivot(['excluded']);
    }

    public function getRelationForProductTableType($tableType)
    {
        //
        if ($tableType === 'webFamily' || $tableType === 'webCategory') {
            $relationName = substr($tableType, 0, -1);
            $relationName .= 'ies';
        } else {
            $relationName = $tableType . 's';
        }
        return $this->$relationName();
    }

    public function isTriggered(Customer $soldToCustomer, $webCartItems)
    {
        return true;
    }
}
