<?php

namespace Marcolin\Models;

class WebCustomerLimit extends WebModel
{
    protected $table = 'WebCustomerLimits';
    protected $fillable = ['customer_id', 'limit_type', 'limit_value'];

    public static $types = [
        'minimum_order_quantity' => 'Minimum Order Quantity',
        'maximum_order_quantity' => 'Maximum Order Quantity',
        'minimum_order_dollar' => 'Minimum Order Dollars',
        'maximum_order_dollar' => 'Maximum Order Dollars',
    ];

    public function customer()
    {
        return $this->belongsTo(Customer::class, 'customer_id', 'id');
    }
}
