<?php
/**
 * Created by PhpStorm.
 * User: cbarranco
 * Date: 1/19/2017
 * Time: 10:35 AM
 */

namespace Marcolin\Listeners;


use Illuminate\Support\Facades\Mail;
use Marcolin\Events\UserWasRegistered;


/**
 * Sends an email to the customer to provide information about their new account.
 *
 * Class EmailNewUserConfirmation
 * @package Marcolin\Listeners
 */
class EmailNewUserConfirmation
{

    public function construct()
    {

    }

    public function handle(UserWasRegistered $event)
    {
        Mail::send(
            'marcolin::emails.newUserConfirmation',
            [
                'webUser' => $event->webUser,
                'temporaryPassword' => $event->temporaryPassword,
                'url' => config('marcolin.b2b.url')
            ],
            function ($mail) use ($event) {
                $mail->to($event->webUser->email);

                foreach (config('marcolin.emailDestinations.newUserConfirmation.to', []) as $to) {
                    if (strlen($to)) $mail->to($to);
                }

                foreach (config('marcolin.emailDestinations.newUserConfirmation.bcc', []) as $bcc) {
                    if (strlen($bcc)) $mail->bcc($bcc);
                }

                $mail->from(config('mail.from_registration.address'), config('mail.from_registration.name'));

                $mail->subject(trans('marcolin::email.newUserConfirmationSubject'));
            }
        );
    }
}