<?php

namespace Marcolin\Models;

use DB;
use Illuminate\Database\Eloquent\Model;


class AutocatCatalogItem extends UuidModel
{
    use HasCommitSequence;

    protected $table = "AutocatCatalogItems";

    protected static $morphMap = [
        'webStyle' => WebStyle::class,
    ];

    public static function getMorphMap()
    {
        return self::$morphMap;
    }

    public static function getItemClass($morphMapKey)
    {
        return array_get(self::$morphMap, $morphMapKey);
    }

    public function autocatCatalog()
    {
        return $this->belongsTo(AutocatCatalog::class, 'autocatCatalog_id', 'id');
    }

    public function autocatCatalogItemModifiers()
    {
        return $this->hasMany(AutocatCatalogItemModifier::class, 'autocatCatalogItem_id', 'id');
    }

    public function comments()
    {
        return $this->belongsToMany(AutocatCatalogComment::class, 'AutocatCatalogItem_AutocatCatalogComment', 'item_id', 'comment_id')->wherePivot('deleted_at', '=', '0000-00-00 00:00:00');
    }

    public function item()
    {
        return $this->morphTo();
    }

    public function getIsNewAttribute() {
        $is_new_modifier = $this->autocatCatalogItemModifiers->where('modifier_type', 'is_new')->first();
        $is_new = isset($is_new_modifier) ? $is_new_modifier->modifier_value : 0;
        return $is_new;
    }

    public function getDefaultIsRxableAttribute() {
        return $this->item->webUnits->first()->unit->rxAble && $this->item->style->productType == 'S';
    }

    public function getIsRxableAttribute() {
        $is_rxable_modifier = $this->autocatCatalogItemModifiers->where('modifier_type', 'is_rxable')->first();
        $is_rxable = isset($is_rxable_modifier) ? $is_rxable_modifier->modifier_value : $this->default_is_rxable;
        return $is_rxable;
    }

    public function getPageBreakAfterAttribute() {
        $page_break_after_modifier = $this->autocatCatalogItemModifiers->where('modifier_type', 'page_break_after')->first();
        $page_break_after = isset($page_break_after_modifier) ? $page_break_after_modifier->modifier_value : 0;
        return $page_break_after;
    }

    public function getHasBeenEditedAttribute() {
        return $this->is_new == 1
            || $this->is_rxable != $this->default_is_rxable
            || $this->page_break_after == 1
            || count($this->comments) > 0
            ;
    }
}
