<?php

namespace Marcolin\Providers;

use Illuminate\Contracts\Events\Dispatcher as DispatcherContract;
use Illuminate\Foundation\Support\Providers\EventServiceProvider as ServiceProvider;
use Marcolin\Events\OrderWasPlaced;
use Marcolin\Events\ReturnWasPlaced;
use Marcolin\Events\SampleReturnWasPlaced;
use Marcolin\Events\SendOrderAlert;
use Marcolin\Events\UserWasRegistered;
use Marcolin\Listeners\EmailNewUserAlert;
use Marcolin\Listeners\EmailNewUserConfirmation;
use Marcolin\Listeners\EmailOrderAlert;
use Marcolin\Listeners\EmailOrderConfirmation;
use Marcolin\Listeners\EmailReturnAuth;
use Marcolin\Listeners\EmailSampleReturnAuth;

class MarcolinB2BSharedEventServiceProvider extends ServiceProvider
{
    /**
     * The event listener mappings for the application.
     *
     * @var array
     */
    protected $listen = [
        
        SendOrderAlert::class => [
            EmailOrderAlert::class,
        ],
        OrderWasPlaced::class => [
            EmailOrderConfirmation::class,
        ],
        ReturnWasPlaced::class => [
            EmailReturnAuth::class,
        ],
        SampleReturnWasPlaced::class => [
            EmailSampleReturnAuth::class,
        ],
        UserWasRegistered::class => [
            EmailNewUserAlert::class,
            EmailNewUserConfirmation::class,
        ],
    ];

    /**
     * Register any other events for your application.
     *
     * @return void
     */
    public function boot()
    {
        parent::boot();
    }
}
