<?php

namespace Marcolin\Models;

/**
 * Class PromotionAction
 * @package Marcolin\Models
 */
class PromotionAction extends WebModel {
    protected $table = 'PromotionActions';
    protected $fillable = ['sequence', 'action_id', 'action_type'];

    use HasCommitSequence;

    // Overrides Model::boot(), used to define custom 'created' and 'deleted' states
    public static function boot() {
        parent::boot();
        // Create a row for the actual action before creating the polymorphic relationship row in PromotionActions
        static::created(function (PromotionAction $action) {
            $className = $action->getActualClassNameForMorph($action->action_type);
            $details = $className::create();
            $action->details()->associate($details);
            $action->save();
        });
        // Delete the row for the actual action when deleting the polymorphic relationship row in PromotionActions
        static::deleted(function (PromotionAction $action) {
            $details = $action->details;
            $details->delete();
        });
    }

    /**
     * Get the relationship to the WebPromotion object tied to this action
     * @return \Illuminate\Database\Eloquent\Relations\BelongsTo
     */
    public function promotion() {
        return $this->belongsTo(WebPromotion::class, 'promotion_id', 'id');
    }

    /**
     * Get the relationship to the actual class type for the action
     * @return \Illuminate\Database\Eloquent\Relations\BelongsTo
     */
    public function details() {
        return $this->belongsTo($this->getActualClassNameForMorph($this->action_type), 'action_id', 'id');
    }
}