<?php

namespace Marcolin\Models;

use DB;


class SurveyResponse extends UuidModel
{
    protected $table = "SurveyResponses";

    use HasCommitSequence;

    public function surveyResponseItems()
    {
        return $this->hasMany(SurveyResponseItem::class, 'surveyResponse_id', 'id');
    }

    public function surveyAdminComments()
    {
        return $this->hasMany(SurveyAdminComment::class, 'surveyResponse_id', 'id');
    }

    public function customer()
    {
        return $this->belongsTo(Customer::class, 'customer_id', 'id');
    }

    public function salesRep()
    {
        return $this->belongsTo(SalesRep::class, 'salesrep_id', 'id');
    }

    public function survey()
    {
        return $this->belongsTo(Survey::class, 'survey_id', 'id');
    }

    public function surveyStatus()
    {
        return $this->belongsTo(SurveyStatus::class, 'surveyStatus_id', 'id');
    }
}
