<?php

namespace Marcolin\Models;

use Illuminate\Database\Eloquent\Collection;

class RebateLevel extends WebModel
{

    protected $table = 'RebateLevels';

    public function webSilo()
    {
        return $this->belongsTo(WebSilo::class, 'websilo_id', 'id');
    }

    public function getNextHeigherRebateLevelAttribute() {
        return $this->webSilo->rebateLevels()->where('minAmount', '>', $this->minAmount)->orderBy('minAmount', 'asc')->first();
    }

    public function getNextLowerRebateLevelAttribute() {
        return $this->webSilo->rebateLevels()->where('minAmount', '<', $this->minAmount)->orderBy('minAmount', 'desc')->first();
    }
}