<?php

namespace Marcolin\Models;

use DB;


class SurveyResponse extends UuidModel
{
    protected $table = "SurveyResponses";

    use HasCommitSequence;

    public function surveyResponseItems()
    {
        return $this->hasMany(SurveyResponseItem::class, 'surveyResponse_id', 'id');
    }

    public function surveyAdminComments()
    {
        return $this->hasMany(SurveyAdminComment::class, 'surveyResponse_id', 'id');
    }

    public function customer()
    {
        if ($this->customer_type == 'guest') {
            return $this->belongsTo(GuestAccount::class, 'customer_id', 'id');
        } else {
            return $this->belongsTo(Customer::class, 'customer_id', 'id');
        }
    }

    public function salesRep()
    {
        return $this->belongsTo(SalesRep::class, 'salesrep_id', 'id');
    }

    public function survey()
    {
        return $this->belongsTo(Survey::class, 'survey_id', 'id');
    }

    public function surveyStatus()
    {
        return $this->belongsTo(SurveyStatus::class, 'surveyStatus_id', 'id');
    }
    
    public function isTomFord() {
        // Yeah this sucks, but I did this in like 5 minutes after a Carlo call, it's the Tom Ford Agreement and the Tom Ford Survey ids
        return $this->survey_id == 15 || $this->survey_id == 22;
    }
}
