<?php

namespace Hilco\Models;

use Illuminate\Database\Eloquent\Builder;
use Illuminate\Database\Eloquent\Relations\BelongsToMany;
use Illuminate\Support\Collection;
use Illuminate\Support\Facades\DB;
use Venturecraft\Revisionable\RevisionableTrait;

class WebHierarchy extends WebModel {
	protected $table = "WebHierarchies";
    protected $fillable = [
        'name',
        'is_default',
    ];
	protected $casts = [
	    'is_default' => 'boolean'
	];

	public function webGroups() {
		return $this->belongsToMany(WebGroup::class, 'WebGroup_WebHierarchy', 'webhierarchy_id', 'webgroup_id');
	}

	public function webSilos() {
	    return $this->hasMany(WebSilo::class, 'webhierarchy_id', 'id');
    }

    public function webGroupsForLayout() {
	    return $this
            ->webGroups()
            ->isVisible()
            ->hasVisibleChildren()
            ->alphabetical()
            ->with([
                'translations',
                'webSiloOverride',
                'webCategories' => function ($query) {
                    return $query
                        ->isVisible()
                        ->hasVisibleChildren()
                        ->alphabetical()
                        ->with([
                            'translations',
                            'webSiloOverride',
                            'webCollections' => function ($query) {
                                return $query
                                    ->isVisible()
                                    ->hasVisibleChildren()
                                    ->alphabetical()
                                    ->with(['translations'])
                                ;
                            }
                        ])
                    ;
                }
            ])
        ;
    }

    public function scopeHasVisibleChildren(Builder $query, $activeWebSilo = false, $activeCountry = false, $activePlant = false) {
	    return $query
            ->whereHas('webGroups', function ($query) use ($activeWebSilo, $activeCountry, $activePlant) {
                return $query->hasVisibleChildren($activeWebSilo, $activeCountry, $activePlant);
            })
        ;
    }

    public function scopeHasVisibleParents(Builder $query, $activeWebSilo = false) {
	    return $query
            ->whereHas('webSilos', function ($query) use ($activeWebSilo) {
                return $query->isActiveWebSilo($activeWebSilo);
            })
        ;
    }

    public function scopeHasSolrVisibleParents(Builder $query) {
        return $query
            ->whereHas('webSilos', function ($query) {
                return $query->where('is_visible', '1');
            })
            ;
    }

    use RevisionableTrait;
}
