<?php

namespace Hilco;

use Hilco\Models\Customer;
use Hilco\Models\WebSilo;
use Hilco\Models\WebUrl;

class B2BHelper {
    protected $activeCustomer;
    protected $activeWebSilo;
    protected $activeShippingAddress;

    public function __construct() {
        $activeShippingAddress = null;
        $this->loadActiveCustomer();
    }

    protected function loadActiveCustomer() {
        $this->activeCustomer = false;

        $aliasedCustomerId = session()->get('aliasedCustomerId', false);
        if ($aliasedCustomerId) {
            $this->activeCustomer = Customer::with('segments.address.plant', 'discounts')->find($aliasedCustomerId);
        } else {
            $user = auth()->user();
            if ($user) $this->activeCustomer = $user->customer;
        }

        $this->setActiveShippingAddress();

        $this->loadActiveWebSilo();
    }

    protected function loadActiveWebSilo() {
        $activeWebSilo = false;

        $activeWebSiloId = session()->get('activeWebSiloId', false);
        if (!$activeWebSiloId) {
            if (auth()->user()) {
                $defaultWebSilo = auth()->user->defaultWebSilo;
                if ($defaultWebSilo) {
                    $activeWebSilo = $defaultWebSilo;
                }
            }

            if (!$activeWebSiloId) {
                $query = WebSilo::with('plants', 'webLandingPage');

                if ($this->activeCustomer) {
                    $cust_cat_summary = $this->activeCustomer->customerCategory->cust_cat_summary;
                    $divisions = $this->activeCustomer->divisions->pluck('id');
                    $query->whereHas('divisionRules', function ($query) use ($divisions) {
                        $query->whereIn('Divisions.id', $divisions);
                    })->whereHas('customerCategorySummaryRules', function ($query) use ($cust_cat_summary) {
                        $query->where('cust_cat_summary', $cust_cat_summary);
                    });
                } else {
                    $webUrl = WebUrl::current()->first();
                    if (!is_null($webUrl)) {
                        $query->whereHas('webUrl', function ($query) use ($webUrl) {
                            $query->where('id', '=', $webUrl->id);
                        });
                    }
                }
                $result = $query->first();
                if (!is_null($result)) $activeWebSilo = $result;
            }

            if ($activeWebSilo) session()->put('activeWebSiloId', $activeWebSilo->id);
        }

        if (!$activeWebSilo) $activeWebSilo = WebSilo::first();
        $this->activeWebSilo = $activeWebSilo;
        return $this->activeWebSilo;
    }

    public function aliasAs($customerId = false) {
        if ($customerId) {
            session()->put('aliasedCustomerId', $customerId);
        } else {
            session()->forget('aliasedCustomerId');
        }
        $this->loadActiveCustomer();
    }

    public function isAliased() {
        return (session()->get('aliasedCustomerId', false));

    }

    public function stopAliasing() {
        $this->aliasAs(false);
    }

    public function setActiveShippingAddress($customerShippingAddress = false) {
        if ($customerShippingAddress === false) {
            if ($this->activeCustomer) {
                $customerShippingAddress = $this->activeCustomer->default_shipping_address;
            }
        }
        $this->activeShippingAddress = $customerShippingAddress;
        return $this->activeShippingAddress;
    }

    public function activeCustomer() {
        return $this->activeCustomer;
    }

    public function activeShippingAddress() {
        return $this->activeShippingAddress;
    }

    public function activeCountry() {
        if ($this->activeShippingAddress) return $this->activeShippingAddress()->country;

        return null;
    }

    public function activePriceList() {
        $activePriceList = 'Catalog';
        if ($this->activeCustomer) {
            $customerPriceList = $this->activeCustomer->default_price_list;
            if ($customerPriceList) $activePriceList = $customerPriceList;
        }

        return $activePriceList;
    }

    public function activeCurrency() {
        $activeCurrency = 'USD';

        if ($this->activeCustomer) {
            $activeCurrency = $this->activeCustomer->currency;
        }

        return $activeCurrency;
    }

    public function activeWebSilo() {
        return $this->activeWebSilo;
    }
}