<?php

namespace Hilco\Models;

use Illuminate\Database\Eloquent\Relations\BelongsTo;

/**
 * @property-read integer $id
 * @property-read integer $importsalesorderline_id
 * @property-read float $discount_amount
 * @property-read Import_SalesOrderLine $importSalesOrderLine
 */
class Import_SalesOrderDiscLine extends WebModel {
    protected $table = "Import_SalesOrderDiscLines";

    /**
     * @return BelongsTo
     */
    public function importSalesOrderLine(): BelongsTo {
        return $this->belongsTo(Import_SalesOrderLine::class, "importsalesorderline_id", "id");
    }

}