<?php

namespace Hilco\Models;

/**
 * Hilco\Models\ProductCategorySummaries
 *
 * @property mixed $id
 * @property string $product_category_summary
 * @property string $date_created
 * @property string $date_modified
 * @property string $deleted_at
 * @property-read \Hilco\Models\ProductCategory $categoryGroup
 * @property-read mixed $id_string
 * @method static \Illuminate\Database\Query\Builder|\Hilco\Models\ProductCategorySummaries whereId($value)
 * @method static \Illuminate\Database\Query\Builder|\Hilco\Models\ProductCategorySummaries whereProductCategorySummary($value)
 * @method static \Illuminate\Database\Query\Builder|\Hilco\Models\ProductCategorySummaries whereDateCreated($value)
 * @method static \Illuminate\Database\Query\Builder|\Hilco\Models\ProductCategorySummaries whereDateModified($value)
 * @method static \Illuminate\Database\Query\Builder|\Hilco\Models\ProductCategorySummaries whereDeletedAt($value)
 * @mixin \Eloquent
 * @property string $date_uploaded
 * @method static \Illuminate\Database\Query\Builder|\Hilco\Models\ProductCategorySummaries whereDateUploaded($value)
 */
class ProductCategorySummaries extends WebModel {
	protected $table = 'ProductCategorySummaries';

	/**
	 * @return \Illuminate\Database\Eloquent\Relations\HasMany
	 */
	public function categoryGroup()
	{
		return $this->hasMany(ProductCategoryGroup::class, 'productcategorysummary_id', 'id');
	}

	/**
	 * @return \Illuminate\Database\Eloquent\Collection|static[]
	 */
	public static function catSummariesList()
	{
		return static::get(['id', 'product_category_summary']);
	}
}
