<?php
/**
 * Created by PhpStorm.
 * User: ntaylor-visionware
 * Date: 12/8/17
 * Time: 4:31 PM
 */

namespace Hilco\Models;

use DB;

/**
 * Class Promotion_SalesOrder
 * @package Hilco\Models
 * @property mixed $id
 * @property integer $promotion_id
 * @property mixed $salesorder_id
 * @property bool $applied
 */
class Promotion_SalesOrder extends UuidModel {
    protected $table = 'Promotion_SalesOrder';
    protected $fillable = ['promotion_id', 'salesorder_id', 'applied'];

    public function promotion() {
        return $this->belongsTo(Promotion::class, 'promotion_id', 'id');
    }

    public function order() {
        return $this->belongsTo(Order::class, 'salesorder_id', 'id');
    }

}