<?php

namespace Hilco\Models;

use Illuminate\Database\Eloquent\Builder;
use Illuminate\Database\Eloquent\Model;

/**
 * M3 discount models table
 * @property-read string $DIPO
 * @property-read string $TX08
 * @method static Builder byDiscModel($discModel)
 */
class OGDIPO extends Model implements PriceIngestModel {
    protected $table = "OGDIPO";

    const NUM_PRIORITY_LEVELS = 10; // PC1*, PC2*, PC3*, ..., PC9*, PC0*
    const NUM_PC_RULES = 5; // PC*1, PC*2, PC*3, etc

    /**
     * @param Builder $query
     * @param $discModel
     * @return Builder
     */
    public function scopeByDiscModel (Builder $query, $discModel): Builder {
        return $query->where('DISY', "=", "$discModel");
    }

    /**
     * @return string
     */
    public function getBucketNo(): string {
        return $this->DIPO;
    }

    /**
     * @return string
     */
    public function getBucketName(): string {
        return $this->TX08;
    }

    /**
     * @param $rulesetNo
     * @param $ruleNo
     * @return string
     */
    public function getRule ($rulesetNo, $ruleNo): string {
        $pcCol = "PC$rulesetNo$ruleNo";
        return $this->$pcCol;
    }

    /**
     * @return string
     */
    public static function getTemporaryTableCreateSQL(): string {
        return <<<SQLEND
CREATE TEMPORARY TABLE `m3`.`OGDIPO_staging` (
  `CONO` varchar(3) NOT NULL,
  `DISY` varchar(10) NOT NULL,
  `DIPO` varchar(1) NOT NULL,
  `TX40` varchar(32) NOT NULL,
  `TX15` varchar(16) NOT NULL,
  `TX08` varchar(8) NOT NULL,
  `DACC` varchar(1) NOT NULL,
  `DCHA` varchar(1) NOT NULL,
  `DPST` varchar(1) NOT NULL,
  `DDSU` varchar(1) NOT NULL,
  `CUCD` varchar(3) NOT NULL,
  `ALDP` varchar(1) NOT NULL,
  `ALPP` varchar(1) NOT NULL,
  `DITP` varchar(1) NOT NULL,
  `DIBE` varchar(1) NOT NULL,
  `DIRE` varchar(1) NOT NULL,
  `IDSC` varchar(1) NOT NULL,
  `SGGB` varchar(2) NOT NULL,
  `SGGC` varchar(1) NOT NULL,
  `SGGU` varchar(8) NOT NULL,
  `PC11` varchar(6) NOT NULL,
  `PC12` varchar(6) NOT NULL,
  `PC13` varchar(6) NOT NULL,
  `PC21` varchar(6) NOT NULL,
  `PC22` varchar(6) NOT NULL,
  `PC23` varchar(6) NOT NULL,
  `PC31` varchar(6) NOT NULL,
  `PC32` varchar(6) NOT NULL,
  `PC33` varchar(6) NOT NULL,
  `PC41` varchar(6) NOT NULL,
  `PC42` varchar(6) NOT NULL,
  `PC43` varchar(6) NOT NULL,
  `PC51` varchar(6) NOT NULL,
  `PC52` varchar(6) NOT NULL,
  `PC53` varchar(6) NOT NULL,
  `PC61` varchar(6) NOT NULL,
  `PC62` varchar(6) NOT NULL,
  `PC63` varchar(6) NOT NULL,
  `PC71` varchar(6) NOT NULL,
  `PC72` varchar(6) NOT NULL,
  `PC73` varchar(6) NOT NULL,
  `PC81` varchar(6) NOT NULL,
  `PC82` varchar(6) NOT NULL,
  `PC83` varchar(6) NOT NULL,
  `PC91` varchar(6) NOT NULL,
  `PC92` varchar(6) NOT NULL,
  `PC93` varchar(6) NOT NULL,
  `PC01` varchar(6) NOT NULL,
  `PC02` varchar(6) NOT NULL,
  `PC03` varchar(6) NOT NULL,
  `ACRF` varchar(8) NOT NULL,
  `DICA` varchar(1) NOT NULL,
  `PCHM` varchar(1) NOT NULL,
  `TXID` varchar(3) NOT NULL,
  `RGDT` varchar(8) NOT NULL,
  `RGTM` varchar(6) NOT NULL,
  `LMDT` varchar(8) NOT NULL,
  `CHNO` varchar(3) NOT NULL,
  `CHID` varchar(8) NOT NULL,
  `CORD` varchar(1) NOT NULL,
  `LMTS` varchar(32) NOT NULL,
  `TEPY` varchar(8) NOT NULL,
  `PC04` varchar(6) NOT NULL,
  `PC05` varchar(6) NOT NULL,
  `PC14` varchar(6) NOT NULL,
  `PC15` varchar(6) NOT NULL,
  `PC24` varchar(6) NOT NULL,
  `PC25` varchar(6) NOT NULL,
  `PC34` varchar(6) NOT NULL,
  `PC35` varchar(6) NOT NULL,
  `PC44` varchar(6) NOT NULL,
  `PC45` varchar(6) NOT NULL,
  `PC54` varchar(6) NOT NULL,
  `PC55` varchar(6) NOT NULL,
  `PC64` varchar(6) NOT NULL,
  `PC65` varchar(6) NOT NULL,
  `PC74` varchar(6) NOT NULL,
  `PC75` varchar(6) NOT NULL,
  `PC84` varchar(6) NOT NULL,
  `PC85` varchar(6) NOT NULL,
  `PC94` varchar(6) NOT NULL,
  `PC95` varchar(6) NOT NULL,
  `EDC1` varchar(1) NOT NULL,
  `EDC2` varchar(1) NOT NULL,
  `EDC3` varchar(1) NOT NULL,
  `EDC4` varchar(1) NOT NULL,
  `EDC5` varchar(1) NOT NULL,
  `EDC6` varchar(1) NOT NULL,
  `ALGP` varchar(1) NOT NULL,
  `accountingEntity` varchar(3) NOT NULL,
  `deleted` varchar(5) NOT NULL,
  `timestamp` varchar(32) NOT NULL,
  `variationNumber` varchar(16) NOT NULL
) ENGINE=InnoDB DEFAULT CHARSET=utf8;
SQLEND;
    }

    /**
     * @return array
     */
    public static function getInsertableColumns(): array {
        return [
            'CONO',
            'DISY',
            'DIPO',
            'TX40',
            'TX15',
            'TX08',
            'DACC',
            'DCHA',
            'DPST',
            'DDSU',
            'CUCD',
            'ALDP',
            'ALPP',
            'DITP',
            'DIBE',
            'DIRE',
            'IDSC',
            'SGGB',
            'SGGC',
            'SGGU',
            'PC11',
            'PC12',
            'PC13',
            'PC21',
            'PC22',
            'PC23',
            'PC31',
            'PC32',
            'PC33',
            'PC41',
            'PC42',
            'PC43',
            'PC51',
            'PC52',
            'PC53',
            'PC61',
            'PC62',
            'PC63',
            'PC71',
            'PC72',
            'PC73',
            'PC81',
            'PC82',
            'PC83',
            'PC91',
            'PC92',
            'PC93',
            'PC01',
            'PC02',
            'PC03',
            'ACRF',
            'DICA',
            'PCHM',
            'TXID',
            'RGDT',
            'RGTM',
            'LMDT',
            'CHNO',
            'CHID',
            'CORD',
            'LMTS',
            'TEPY',
            'PC04',
            'PC05',
            'PC14',
            'PC15',
            'PC24',
            'PC25',
            'PC34',
            'PC35',
            'PC44',
            'PC45',
            'PC54',
            'PC55',
            'PC64',
            'PC65',
            'PC74',
            'PC75',
            'PC84',
            'PC85',
            'PC94',
            'PC95',
            'EDC1',
            'EDC2',
            'EDC3',
            'EDC4',
            'EDC5',
            'EDC6',
            'ALGP',
            'accountingEntity',
            'deleted',
            'timestamp',
            'variationNumber',
        ];
    }
}