<?php

namespace Hilco\Models;

use Illuminate\Database\Eloquent\Builder;
use Illuminate\Database\Eloquent\Model;

/**
 * M3 general object mapping
 * @property-read string $OBV2
 * @method static Builder byPriceListTable($priceListTable)
 */
class CROBJC extends Model implements PriceIngestModel {
    protected $table = "CROBJC";

    const PRICE_LIST_SELECT = 'OIS831';
    const NUM_PRIORITY_LEVELS = 10; // PC0*, PC1*, PC2*, PC3*, etc
    const NUM_PC_RULES = 5; // PC*1, PC*2, PC*3, PC*4, PC*5

    /**
     * @return string
     */
    public function getPriceListTable(): string {
        return $this->getOBV2();
    }

    /**
     * @return string
     */
    public function getOBV2(): string {
        return $this->OBV2;
    }

    /**
     * @param Builder $query
     * @param string $priceListTable
     * @return Builder
     */
    public function scopeByPriceListTable (Builder $query, string $priceListTable): Builder {
        $pgnm = self::PRICE_LIST_SELECT;
        return $query->where('OBV1', "$pgnm")->where('OBV2', "$priceListTable");
    }

    /**
     * @param $rulesetNo
     * @param $ruleNo
     * @return string
     */
    public function getRule ($rulesetNo, $ruleNo): string {
        $pcCol = "PC$rulesetNo$ruleNo";
        return $this->$pcCol;
    }

    /**
     * @return string
     */
    public static function getTemporaryTableCreateSQL(): string {
        return <<<SQLEND
CREATE TEMPORARY TABLE `m3`.`CROBJC_staging` (
  `CONO` varchar(3) NOT NULL,
  `PGNM` varchar(8) DEFAULT NULL,
  `OBV1` varchar(6) NOT NULL,
  `OBV2` varchar(15) NOT NULL,
  `OBV3` varchar(1) NOT NULL,
  `PCHM` varchar(1) NOT NULL,
  `STAT` varchar(2) NOT NULL,
  `PC01` varchar(6) NOT NULL,
  `PC02` varchar(6) NOT NULL,
  `PC03` varchar(6) NOT NULL,
  `PC04` varchar(6) NOT NULL,
  `PC05` varchar(6) NOT NULL,
  `PC11` varchar(6) NOT NULL,
  `PC12` varchar(6) NOT NULL,
  `PC13` varchar(6) NOT NULL,
  `PC14` varchar(6) NOT NULL,
  `PC15` varchar(6) NOT NULL,
  `PC21` varchar(6) NOT NULL,
  `PC22` varchar(6) NOT NULL,
  `PC23` varchar(6) NOT NULL,
  `PC24` varchar(6) NOT NULL,
  `PC25` varchar(6) NOT NULL,
  `PC31` varchar(6) NOT NULL,
  `PC32` varchar(6) NOT NULL,
  `PC33` varchar(6) NOT NULL,
  `PC34` varchar(6) NOT NULL,
  `PC35` varchar(6) NOT NULL,
  `PC41` varchar(6) NOT NULL,
  `PC42` varchar(6) NOT NULL,
  `PC43` varchar(6) NOT NULL,
  `PC44` varchar(6) NOT NULL,
  `PC45` varchar(6) NOT NULL,
  `PC51` varchar(6) NOT NULL,
  `PC52` varchar(6) NOT NULL,
  `PC53` varchar(6) NOT NULL,
  `PC54` varchar(6) NOT NULL,
  `PC55` varchar(6) NOT NULL,
  `PC61` varchar(6) NOT NULL,
  `PC62` varchar(6) NOT NULL,
  `PC63` varchar(6) NOT NULL,
  `PC64` varchar(6) NOT NULL,
  `PC65` varchar(6) NOT NULL,
  `PC71` varchar(6) NOT NULL,
  `PC72` varchar(6) NOT NULL,
  `PC73` varchar(6) NOT NULL,
  `PC74` varchar(6) NOT NULL,
  `PC75` varchar(6) NOT NULL,
  `PC81` varchar(6) NOT NULL,
  `PC82` varchar(6) NOT NULL,
  `PC83` varchar(6) NOT NULL,
  `PC84` varchar(6) NOT NULL,
  `PC85` varchar(6) NOT NULL,
  `PC91` varchar(6) NOT NULL,
  `PC92` varchar(6) NOT NULL,
  `PC93` varchar(6) NOT NULL,
  `PC94` varchar(6) NOT NULL,
  `PC95` varchar(6) NOT NULL,
  `TXID` varchar(3) NOT NULL,
  `RGDT` varchar(8) NOT NULL,
  `RGTM` varchar(6) NOT NULL,
  `LMDT` varchar(8) NOT NULL,
  `CHNO` varchar(3) NOT NULL,
  `CHID` varchar(8) NOT NULL,
  `accountingEntity` varchar(3) NOT NULL,
  `archived` varchar(255) NOT NULL,
  `deleted` varchar(5) NOT NULL,
  `timestamp` varchar(32) NOT NULL,
  `variationNumber` varchar(16) NOT NULL
) ENGINE=InnoDB DEFAULT CHARSET=utf8;
SQLEND;
    }

    /**
     * @return array
     */
    public static function getInsertableColumns(): array {
        return [
            'CONO',
            'PGNM',
            'OBV1',
            'OBV2',
            'OBV3',
            'PCHM',
            'STAT',
            'PC01',
            'PC02',
            'PC03',
            'PC04',
            'PC05',
            'PC11',
            'PC12',
            'PC13',
            'PC14',
            'PC15',
            'PC21',
            'PC22',
            'PC23',
            'PC24',
            'PC25',
            'PC31',
            'PC32',
            'PC33',
            'PC34',
            'PC35',
            'PC41',
            'PC42',
            'PC43',
            'PC44',
            'PC45',
            'PC51',
            'PC52',
            'PC53',
            'PC54',
            'PC55',
            'PC61',
            'PC62',
            'PC63',
            'PC64',
            'PC65',
            'PC71',
            'PC72',
            'PC73',
            'PC74',
            'PC75',
            'PC81',
            'PC82',
            'PC83',
            'PC84',
            'PC85',
            'PC91',
            'PC92',
            'PC93',
            'PC94',
            'PC95',
            'TXID',
            'RGDT',
            'RGTM',
            'LMDT',
            'CHNO',
            'CHID',
            'accountingEntity',
            'archived',
            'deleted',
            'timestamp',
            'variationNumber',
        ];
    }
}