<?php

namespace Hilco\Models;

use Illuminate\Database\Eloquent\Relations\BelongsTo;

/**
 * Hilco\Models\InvoiceLine
 * @property-read string $invc_no
 */
class InvoiceLine extends WebModel {
    protected $table = "InvoiceLines";

    public function getInvoiceNumberFull(): string {
        return $this->invc_no;
    }

    public function getInvoiceNumberNoYear(): string {
        $fullInvcNo = $this->invc_no;
        $year = date("Y");
        if (str_starts_with($fullInvcNo, $year)) {
            $noYearStr = substr($this->invc_no, 4);
            if ($noYearStr) {
                return $noYearStr;
            }
        }
        return $this->invc_no;
    }

    public function importSalesOrder(): BelongsTo {
        return $this->belongsTo(Import_SalesOrder::class, "importsalesorder_id", "id");
    }

    public function importSalesOrderLine(): BelongsTo {
        return $this->belongsTo(Import_SalesOrderLine::class, "importsalesorderline_id", "id");
    }
}