<?php

namespace Hilco\Models;

use Illuminate\Database\Eloquent\Relations\BelongsTo;

/**
 * Hilco\Models\CustomerAlias
 *
 * @property-read integer $id
 * @property-read string $cust_no
 * @property-read string $alias_no
 * @property-read Customer $customer
 */
class CustomerAlias extends WebModel {
    protected $table = "CustomerAliases";

    /**
     * @return BelongsTo
     */
    public function customer(): BelongsTo {
        return $this->belongsTo(Customer::class, "cust_no", "cust_no");
    }

    /**
     * @return string
     */
    public function getAliasNo(): string {
        return $this->alias_no;
    }

}