<?php
/**
 * Created by PhpStorm.
 * User: steven
 * Date: 7/25/19
 * Time: 11:00 AM
 */

namespace Hilco\GuzzleWrappers;


use GuzzleHttp\Client;

/**
 * Class APIGuzzleWrapper
 * @package Hilco\GuzzleWrappers
 *
 */
class APIGuzzleWrapper extends GuzzleWrapper
{
    public function __construct()
    {
        $this->client = config('hilco-api.api_server_url') ? new Client(['base_uri' => config('hilco-api.api_server_url')]) : null;
    }
    public function get($uri, $corollaryAttributes)
    {
        \Illuminate\Support\Arr::set($corollaryAttributes, 'query.environment', \Illuminate\Support\Arr::has($corollaryAttributes, 'query.environment') ? \Illuminate\Support\Arr::get($corollaryAttributes, 'query.environment') : env('APP_ENV'));
        \Illuminate\Support\Arr::set($corollaryAttributes, 'query.requestFrom', \Illuminate\Support\Arr::has($corollaryAttributes, 'query.requestFrom') ? \Illuminate\Support\Arr::get($corollaryAttributes, 'query.requestFrom') : 'b2b');
        if($this->client){
            $response =  $this->client->get($uri, $corollaryAttributes);
            return $response;
        }
    }

}