<?php

namespace Hilco\Models;

use Illuminate\Database\Eloquent\Relations\BelongsTo;

/**
 * Hilco\Models\VisionWebOrder
 * @property integer $id
 * @property integer $visionweborder_id
 * @property string $lens_side
 * @property string $treatment_code
 * @property VisionWebOrder $visionWebOrder
 */
class VisionWebOrderAddOn extends WebModel {
    protected $table = "VisionWebOrderAddOns";
    protected $fillable = [
        'visionweborder_id',
        'lens_side',
        'treatment_code',
    ];

    /**
     * VisionWebOrder relationship
     * @return BelongsTo
     */
    public function visionWebOrder(): BelongsTo {
        return $this->belongsTo(VisionWebOrder::class, 'visionweborder_id', 'id');
    }

    /**
     * @return string
     */
    public function getLensSide(): string {
        return $this->lens_side;
    }

    /**
     * @return string
     */
    public function getTreatmentCode(): string {
        return $this->treatment_code;
    }

    /**
     * VisionWeb Lens Treatment Codes have a max length of 10 characters and the first 4 are a required internal code.
     * The last 6 characters are the last 6 characters of a 7-character long Hilco M3 item number, with the assumption
     * that the full item number begins with "1".
     * @return string
     */
    public function getItemNoFromTreatmentCode(): string {
        $treatmentCode = $this->getTreatmentCode();
        return "1".substr($treatmentCode, 4);
    }
}