<?php
/**
 * Created by PhpStorm.
 * User: brian
 * Date: 7/16/18
 * Time: 4:41 PM
 */

namespace Hilco\Models;
use Illuminate\Database\Eloquent\Model;

/**
 * Hilco\Models\ApprovalPermissions
 *
 * @property integer $id
 * @property integer $salesrep_id
 * @property integer $approvalreason_id
 * @property integer $division_id
 * @property string $title
 * @property integer $default_permission
 * @property string $expiration_date
 * @property string $date_created
 * @property string $date_modified
 * @property string $date_uploaded
 * @property integer $commit_sequence
 * @property string $deleted_at
 * @method static \Illuminate\Database\Query\Builder|\Hilco\Models\ApprovalPermissions whereId($value)
 * @method static \Illuminate\Database\Query\Builder|\Hilco\Models\ApprovalPermissions whereSalesRepId($value)
 * @method static \Illuminate\Database\Query\Builder|\Hilco\Models\ApprovalPermissions whereApprovalReasonId($value)
 * @method static \Illuminate\Database\Query\Builder|\Hilco\Models\ApprovalPermissions whereDivisionId($value)
 * @method static \Illuminate\Database\Query\Builder|\Hilco\Models\ApprovalPermissions whereTitle($value)
 * @method static \Illuminate\Database\Query\Builder|\Hilco\Models\ApprovalPermissions whereDefaultPermission($value)
 * @method static \Illuminate\Database\Query\Builder|\Hilco\Models\ApprovalPermissions whereExpirationDate($value)
 * @method static \Illuminate\Database\Query\Builder|\Hilco\Models\ApprovalPermissions whereDateCreated($value)
 * @method static \Illuminate\Database\Query\Builder|\Hilco\Models\ApprovalPermissions whereDateModified($value)
 * @method static \Illuminate\Database\Query\Builder|\Hilco\Models\ApprovalPermissions whereDateUploaded($value)
 * @method static \Illuminate\Database\Query\Builder|\Hilco\Models\ApprovalPermissions whereCommitSequence($value)
 * @method static \Illuminate\Database\Query\Builder|\Hilco\Models\ApprovalPermissions whereDeletedAt($value)
 * @mixin \Eloquent
 */

class ApprovalPermissions extends Model {

    use \Hilco\SoftDeletes, \Hilco\Models\HasCommitSequence;

    protected $table = "ApprovalPermissions";
    protected $fillable = ['salesrep_id', 'approvalreason_id', 'division_id', 'title', 'default_permission', 'expiration_date'];

    const UPDATED_AT = 'date_modified';
    const CREATED_AT = 'date_created';
}