<?php

namespace Hilco\Models;

use Illuminate\Database\Query\Builder;

/**
 * Class DeliveryTerm
 * @package Hilco\Models
 * @property-read integer $id
 * @property-read string $delivery_term_code
 * @property-read string $description
 * @method static Builder|DeliveryTerm whereDeliveryTermCode($value)
 */
class DeliveryTerm extends WebModel {
    protected $table = "DeliveryTerms";

    protected static $billCollectTerms      = ['C00', 'C03'];
    protected static $billThirdPartyTerms   = ['T00', 'T03'];
    const FLAT_RATE_2ND_DAY = "F22";
    const FLAT_RATE_OVERNIGHT = "F35";
    const FREE_COLD_PHARM = "FCP";
    const FREE_SHIPPING = "F00";
    const PREDEFINED_TERM = 'D00';

    public static function getBillCollectTerms() {
        return self::$billCollectTerms;
    }

    public static function getBillThirdPartyTerms() {
        return self::$billThirdPartyTerms;
    }

    /**
     * @return DeliveryTerm|null
     */
    public static function getPredefinedTerm(): ?DeliveryTerm {
        return DeliveryTerm::where('delivery_term_code', self::PREDEFINED_TERM)->first();
    }
}