<?php
/**
 * Created by PhpStorm.
 * User: cbarranco
 * Date: 10/4/2016
 * Time: 3:53 PM
 */

namespace Hilco\Models;


use Illuminate\Database\Eloquent\Builder;

class WebSilo_WebUser extends WebModel {
    protected $table = 'WebSilo_WebUser';
    protected $fillable = ['websilo_id', 'webuser_id', 'spending_limit', 'spending_period', 'minimum_order',];

    public function webSilo() {
        return $this->belongsTo(WebSilo::class, 'websilo_id', 'id');
    }

    public function webUser() {
        return $this->belongsTo(WebUser::class, 'webuser_id', 'id');
    }
    
    public function scopeForWebSilo($query, $webSiloId) {
        return $query->where('websilo_id',$webSiloId);
    }
    
    public function scopeForWebUser($query, $webUserId) {
        return $query->where('webuser_id',$webUserId);
    }
}