<?php

namespace Hilco\Models;

/**
 * Class WebGroup_WebHierarchy
 * @package Hilco\Models
 * @property int $id
 * @property int $webgroup_id
 * @property int $webhierarchy_id
 * @property string $date_created
 * @property string $date_modified
 * @property string $date_uploaded
 * @property string $deleted_at
 * @property-read WebGroup $webGroup
 * @property-read WebHierarchy $webHierarchy
 * @method static \Illuminate\Database\Query\Builder|WebGroup_WebHierarchy whereId($value)
 * @method static \Illuminate\Database\Query\Builder|WebGroup_WebHierarchy whereWebGroupId($value)
 * @method static \Illuminate\Database\Query\Builder|WebGroup_WebHierarchy whereWebHierarchyId($value)
 * @method static \Illuminate\Database\Query\Builder|WebGroup_WebHierarchy whereDateCreated($value)
 * @method static \Illuminate\Database\Query\Builder|WebGroup_WebHierarchy whereDateModified($value)
 * @method static \Illuminate\Database\Query\Builder|WebGroup_WebHierarchy whereDateUploaded($value)
 * @method static \Illuminate\Database\Query\Builder|WebGroup_WebHierarchy whereDeletedAt($value)
 */
class WebGroup_WebHierarchy extends WebModel {
    protected $table = 'WebGroup_WebHierarchy';
    protected $fillable = ['webgroup_id', 'webhierarchy_id'];

    /**
     * @return \Illuminate\Database\Eloquent\Relations\BelongsTo
     */
    public function webGroup() {
        return $this->belongsTo(WebGroup::class, 'webgroup_id', 'id');
    }

    /**
     * @return \Illuminate\Database\Eloquent\Relations\BelongsTo
     */
    public function webHierarchy() {
        return $this->belongsTo(WebHierarchy::class, 'webhierarchy_id', 'id');
    }
}