<?php

namespace Hilco\Models;

/**
 * @property-read integer webfamily_id
 * @property-read integer related_id
 * @property-read string related_type
 * @property-read string related_category
 * @property-read WebFamily webFamily
 * @property-read WebFamily|WebPart related
 */
class WebFamily_Related extends WebModel {
    protected $table = "WebFamily_Related";

    public function related() {
        return $this->morphTo();
    }

    public function webFamily() {
        return $this->belongsTo(WebFamily::class, 'webfamily_id', 'id');
    }
}