<?php

namespace Hilco\Models;

use Arr;

/**
 * Hilco\Models\SubscriptionItem
 * @property mixed $subscriptiongroup_id
 * @property int $createdby_webuser_id
 * @property int $lastmodifiedby_webuser_id
 * @property int $part_id
 * @property int $quantity
 * @property string $comment
 * @property float $last_calculated_price
 * @property bool $out_of_stock_event_sent
 * @property bool $discontinued_event_sent
 * @property SubscriptionGroup $subscriptionGroup
 * @property WebUser $createdByWebUser
 * @property WebUser $modifiedByWebUser
 * @property Part $part
 */
class SubscriptionItem extends UuidModel {
    protected $table = 'SubscriptionItems';
    protected $fillable = ['subscriptiongroup_id', 'lastmodifiedby_webuser_id'];

    public function subscriptionGroup() {
        return $this->hasOne(SubscriptionGroup::class, 'id', 'subscriptiongroup_id');
    }

    public function createdByWebUser() {
        return $this->hasOne(WebUser::class, 'id', 'createdby_webuser_id');
    }
    public function modifiedByWebUser() {
        return $this->hasOne(WebUser::class, 'id', 'modifiedby_webuser_id');
    }

    public function part() {
        return $this->hasOne(Part::class, 'id', 'part_id');
    }

    public function getBaseItemKlaviyoArray(): array {
        $part = $this->part;
        $webPart = $part->webPart;
        $webFamily = is_null($webPart) ? null : $webPart->webFamily;
        return [
            'ProductID' => $part->part_no,
            'ProductName' => $part->part_desc,
            'Quantity' => $this->quantity,
            'ProductURL' => route('family.slug', [Arr::get($webFamily, 'slug', ''), Arr::get($webPart, 'id', '')]),
            'SmallImageURL' => WebAsset::urlHelper(['key' => Arr::get($part, 'part_no', ''), 'prefix' => 'pn', 'width' => 150, 'height' => 150]),
            'ImageURL' => WebAsset::urlHelper(['key' => Arr::get($part, 'part_no', ''), 'prefix' => 'pn']),
        ];
    }

    public function getBaseItemWithPricesKlaviyoArray ($itemPrice, $rowTotal): array {
        $baseItemArr = $this->getBaseItemKlaviyoArray();
        $baseItemArr['ItemPrice'] = b2b()->formatPrice($itemPrice);
        $baseItemArr['RowTotal'] = b2b()->formatPrice($rowTotal);
        return $baseItemArr;
    }

    public function getHubSpotEventProperties ($prefix, $autoshipItemObj, $includeRefrig = false, $includeItemType = false): array {
        $part = $this->part;
        $webPart = $part->webPart;
        $webFamily = $webPart->webFamily;
        $props = [
            "$prefix"."_image_url"          => WebAsset::urlHelper([
                'key' => Arr::get($part, 'part_no', ''),
                'prefix' => 'pn',
            ]),
            "$prefix"."_price"              => $autoshipItemObj['discountedPrice'],
            "$prefix"."_product_id"         => $part->part_no,
            "$prefix"."_product_name"       => $part->part_desc,
            "$prefix"."_product_url"        => route('family.slug', [Arr::get($webFamily, 'slug', ''), Arr::get($webPart, 'id', '')]),
            "$prefix"."_quantity"           => $this->quantity,
            "$prefix"."_row_total"          => $autoshipItemObj['discountedPrice'] * $this->quantity,
            "$prefix"."_small_image_url"    => WebAsset::urlHelper([
                'key' => Arr::get($part, 'part_no', ''),
                'prefix' => 'pn',
                'width' => 150,
                'height' => 150,
            ]),
        ];
        if ($includeRefrig) $props["$prefix"."_refrigerated_flag"] = $part->refrig_flag;
        if ($includeItemType) {
            if ($prefix === 'changed_item') $props["$prefix"."_type"] = $part->item_type;
            else $props["$prefix"."_item_type"] = $part->item_type;
        }
        return $props;
    }
}