@if($edit)
    <div class="mceNonEditable component-container" data-component-key="jumbotron">
<a href="#" class="btn btn-danger pull-right delete-component">X</a>
        <h4>@lang('hilco::app.jumbotron')</h4>
        <p>@lang('hilco::app.displays_a_large_banner_across_the_entire_width_of_the_page')</p>
        <div class="view-full-container">
            @include('hilco::components.targetCustomer.viewSelector', ['alternateViews' => $alternateViews ?? []])
            @include('hilco::components.jumbotronView',
            [
                'viewId' => 0,
                'full' => $full,
                'webAssetId' => $webAssetId,
                'alttag' => $alttag,
                'defaultVisibility' => $defaultVisibility ?? 'Visible',
                'visibleDates' => $visibleDates ?? [],
                'visibleDatesFormatted' => $visibleDatesFormatted ?? 'All',
                'default' => true
            ])
            @foreach($alternateViews ?? [] as $altViewId => $altView)
                @include('hilco::components.jumbotronView',
                [
                    'viewId' => $altViewId,
                    'full' => Arr::get($altView, 'full', false),
                    'webAssetId' => Arr::get($altView, 'webAssetId', ''),
                    'alttag' => Arr::get($altView, 'alttag', ''),
                    'targetCustomers' => Arr::get($altView, 'targetCustomers', []),
                    'targetCustomersFormatted' => Arr::get($altView, 'targetCustomersFormatted', 'None'),
                    'visibleDates' => Arr::get($altView, 'visibleDates', []),
                    'visibleDatesFormatted' => Arr::get($altView, 'visibleDatesFormatted', 'None'),
                    'default' => false
                ])
            @endforeach
        </div>
    </div>
@endif

@if($script)
    <script type="text/javascript">
        registerComponent('jumbotron', {
            menuText: '@lang('hilco::app.jumbotron')',
            bladeTemplate: 'hilco::components.jumbotron',
            init: function (body) {
                initViewFunctions(body);
                $(body).on('click', '#jumbotronThumbnail', function() {
                    var container = $(this).closest('.view-container');
                    assets.finder({
                        successFunction: function(data) {
                            var alt;
                            if(data.alttag != null && data.alttag != ""){
                                alt = data.alttag;
                            }else if(data.name != null && data.name != ""){
                                alt = data.name;
                            }else{
                                alt = 'None'
                            }

                            $(container).find('img#jumbotronThumbnail')
                                    .attr('src', data.url)
                                    .attr('alt', alt)
                                    .attr('data-web-asset-id', data.id)
                            ;

                            if(alt != 'None') {
                                $(container).find('.jumbotron-alttag').attr('data-img-alttag', alt);
                            }
                            $(container).find('.jumbotron-alttag').text(alt);
                        }
                    });
                }).on('click', '.jumbotron-alttag', function () {
                    var container = $(this).closest('.view-container');
                    var button = $(this);

                    assets.description({
                        successFunction: function (data) {
                            if(data.alttag != null && data.alttag != ""){
                                $(button).attr('data-img-alttag', data.alt);
                                $(button).text(data.alt);

                                $(container).find('img#jumbotronThumbnail')
                                    .attr('alt', data.alt)
                                ;
                            }

                        }
                    });
                });
            },
            serialize: function (componentNode) {
                var viewDiv = $(componentNode).find('div.view-container.default');
                var alternateViews = {};
                viewDiv.closest('.view-full-container').find('.view-container.alternate').each(function () {;
                    var targetCustomers = {};
                    try{
                        targetCustomers = JSON.parse($(this).attr('data-target-customers'));
                    }catch (e){
                        //use the empty object
                    }
                    var visibleDates = {};
                    try{
                        visibleDates = JSON.parse($(this).attr('data-visible-dates'));
                    }catch (e){
                        //use the empty object
                    }
                    alternateViews[$(this).attr('data-view-id')] = {
                        webAssetId: $(this).find('img#jumbotronThumbnail').data('web-asset-id'),
                        alttag: $(this).find('a.jumbotron-alttag').data('img-alttag'),
                        targetCustomers: targetCustomers,
                        targetCustomersFormatted: $(this).find('.view-targetcustomers').text(),
                        visibleDates: visibleDates,
                        visibleDatesFormatted: $(this).find('.view-visibledates').text(),
                    }
                });
                var visibleDates = {};
                try{
                    visibleDates = JSON.parse(viewDiv.attr('data-visible-dates'));
                }catch (e){
                    //use the empty object
                }
                var result = {
                    webAssetId: viewDiv.find('img#jumbotronThumbnail').data('web-asset-id'),
                    alttag: viewDiv.find('a.jumbotron-alttag').data('img-alttag'),
                    defaultVisibility: viewDiv.attr('data-default-visibility').trim(),
                    visibleDates: visibleDates,
                    visibleDatesFormatted: viewDiv.find('.view-visibledates').text(),
                    alternateViews: alternateViews
                };

                return result;
            },
        });
    </script>
@endif

@if($view)
    @include('hilco::components.targetCustomer.viewRenderer', ['blade' => 'hilco::components.jumbotronView', 'bladeViewArgs' => ['full' => $full, 'webAssetId' => $webAssetId, 'alttag' => $alttag, 'defaultVisibility' => $defaultVisibility ?? 'Visible', 'alternateViews' => $alternateViews?? []], 'mode' => 'view'])
@endif
