<?php
/**
 * Created by PhpStorm.
 * User: brian
 * Date: 11/8/18
 * Time: 2:08 PM
 */

namespace Hilco\Models;

/**
 * Hilco\Models\QueuedOrderSubLine
 *
 * @property mixed $id
 * @property mixed $parent_id
 * @property string $parent_type
 * @property mixed $salesordermainline_id
 * @property integer $division_id
 * @property mixed $salesorder_id
 * @property integer $line_order
 * @property string $line_suborder
 * @property string $date_created
 * @property string $date_modified
 * @property string $date_uploaded
 * @property string $deleted_at
 * @property-read \Hilco\Models\OrderMiscLine $miscLine
 * @property-read \Hilco\Models\QueuedOrderDiscountLine $discountLine
 * @method static \Illuminate\Database\Query\Builder|\Hilco\Models\QueuedOrderSubLine whereId($value)
 * @method static \Illuminate\Database\Query\Builder|\Hilco\Models\QueuedOrderSubLine whereParentId($value)
 * @method static \Illuminate\Database\Query\Builder|\Hilco\Models\QueuedOrderSubLine whereParentType($value)
 * @method static \Illuminate\Database\Query\Builder|\Hilco\Models\QueuedOrderSubLine whereSalesordermainlineId($value)
 * @method static \Illuminate\Database\Query\Builder|\Hilco\Models\QueuedOrderSubLine whereDivisionId($value)
 * @method static \Illuminate\Database\Query\Builder|\Hilco\Models\QueuedOrderSubLine whereSalesorderId($value)
 * @method static \Illuminate\Database\Query\Builder|\Hilco\Models\QueuedOrderSubLine whereLineOrder($value)
 * @method static \Illuminate\Database\Query\Builder|\Hilco\Models\QueuedOrderSubLine whereLineSuborder($value)
 * @method static \Illuminate\Database\Query\Builder|\Hilco\Models\QueuedOrderSubLine whereDateCreated($value)
 * @method static \Illuminate\Database\Query\Builder|\Hilco\Models\QueuedOrderSubLine whereDateModified($value)
 * @method static \Illuminate\Database\Query\Builder|\Hilco\Models\QueuedOrderSubLine whereDateUploaded($value)
 * @method static \Illuminate\Database\Query\Builder|\Hilco\Models\QueuedOrderSubLine whereDeletedAt($value)
 * @mixin \Eloquent
 * @property integer $line_number
 * @method static \Illuminate\Database\Query\Builder|\Hilco\Models\QueuedOrderSubLine whereLineNumber($value)
 * @property-read \Hilco\Models\QueuedOrderAttnLine $attnLine
 * @property-read \Hilco\Models\OrderInstructionLine $instructionLine
 */
class QueuedOrderSubLine extends WebModel
{
    protected $table = 'QueuedSalesOrderSubLines';

    public function miscLine()
    {
        return $this->hasOne(OrderMiscLine::class, 'id', 'parent_id');
    }

    public function attnLine()
    {
        return $this->hasOne(QueuedOrderAttnLine::class, 'id', 'parent_id');
    }

    public function commentLine()
    {
        return $this->hasOne(OrderCommentLine::class, 'id', 'parent_id');
    }

    public function instructionLine()
    {
        return $this->hasOne(OrderInstructionLine::class, 'id', 'parent_id');
    }

    public function discountLine()
    {
        return $this->hasOne(QueuedOrderDiscountLine::class, 'id', 'parent_id');
    }

    public function xrefLine()
    {
        return $this->hasOne(OrderXrefLine::class, 'id', 'parent_id');
    }
}