<?php
/**
 * Created by PhpStorm.
 * User: brian
 * Date: 11/8/18
 * Time: 2:04 PM
 */

namespace Hilco\Models;


class QueuedOrderMainLine extends WebModel
{
    protected $table = 'QueuedSalesOrderMainLines';

    public function partLine() {
        return $this->hasOne(QueuedOrderPartLine::class, 'id', 'parent_id');
    }

    public function partLines() {
        return $this->hasOne(QueuedOrderPartLine::class, 'id', 'parent_id');
    }

    public function salesOrderStatus() {
        return $this->hasMany(SalesOrderStatus::class, 'salesordermainline_id', 'id');
    }

    public function miscLine()
    {
        return $this->hasOne(OrderMiscLine::class, 'id', 'parent_id')->with('miscCharge');
    }

    public function subLines()
    {
        return $this->hasMany(QueuedOrderSubLine::class, 'salesordermainline_id')->where('parent_type', 'SalesOrderDiscLines');
    }

    public function orderLineSchedules()
    {
        return $this->hasMany(SalesOrderLineSchedule::class, 'salesordermainline_id');
    }

    public function discSubLines()
    {
        return $this->hasMany(QueuedOrderSubLine::class, 'salesordermainline_id')->where('parent_type', 'SalesOrderDiscLines')->whereNull('deleted_at')->with('discountLine');
    }

    public function miscSubLines()
    {
        return $this->hasMany(QueuedOrderSubLine::class, 'salesordermainline_id')->where('parent_type', 'SalesOrderMiscLines')->whereNull('deleted_at')->with('miscLine.miscCharge');
    }

    public function attnSubLine() {
        return $this->hasOne(QueuedOrderSubLine::class, 'salesordermainline_id')->where('parent_type', 'SalesOrderAttnLines')->with('attnLine');
    }

    public function instructionSubLine() {
        return $this->hasOne(QueuedOrderSubLine::class, 'salesordermainline_id')->where('parent_type', 'SalesOrderInstructionLines')->with('instructionLine');
    }

    public function xrefSubLine() {
        return $this->hasOne(QueuedOrderSubLine::class, 'salesordermainline_id')->where('parent_type', 'SalesOrderXrefLines')->with('xrefLine');
    }

    public function commentLine()
    {
        return $this->hasOne(QueuedOrderSubLine::class, 'salesordermainline_id')->where('parent_type', 'SalesOrderCommentLines')->with('commentLine');
    }

    public function extractComments($subLine) {
        if (is_null($subLine)) return [];
        $commentLine = $subLine->commentLine;
        $comments = array();
        if ($commentLine->line_comment_all != null && $commentLine->line_comment_all != '') {
            $comments['A'] = $commentLine->line_comment_all;
        }
        if ($commentLine->line_comment_external != null && $commentLine->line_comment_external != '') {
            $comments['E'] = $commentLine->line_comment_external;
        }
        if ($commentLine->line_comment_internal != null && $commentLine->line_comment_internal != '') {
            $comments['I'] = $commentLine->line_comment_internal;
        }
        if ($commentLine->line_comment_display != null && $commentLine->line_comment_display!= '') {
            $comments['D'] = $commentLine->line_comment_display;
        }
        return $comments;
    }

    public function shipPlant() {
        return $this->belongsTo(Plant::class, 'plant_id');
    }

    public function shipWarehouse() {
        return $this->belongsTo(Warehouse::class, 'warehouse_id');
    }

    public function order() {
        return $this->belongsTo(Order::class, 'salesorder_id');
    }

    public function shipBinLocation() {
        return $this->belongsTo(BinLocation::class, 'binlocation_id');
    }

    public function getTotalDiscount() {
        $totalDiscount = 0;
        foreach ($this->discSubLines as $discSubLine) {
            $totalDiscount += $discSubLine->discountLine->discount_amount;
        }
        return $totalDiscount;
    }

    public function getDiscountUnitPriceExtension() {
        return ($this->partLine->unit_price - $this->getTotalDiscount()) * $this->partLine->quantity;
    }
}