<?php
/**
 * Created by PhpStorm.
 * User: brian
 * Date: 11/8/18
 * Time: 1:28 PM
 */

namespace Hilco\Models;

use Carbon\Carbon;
use Hilco\SoftDeletes;
use Illuminate\Support\Facades\DB;

/**
 * Hilco\Models\QueuedOrder
 *
 * @property mixed $id
 * @property mixed $division_id
 * @property mixed $plant_id
 * @property string $invoice_number
 * @property string $web_order_number
 * @property mixed $billto_customersegment_id
 * @property mixed $soldto_customersegment_id
 * @property string $fob
 * @property string $payment_terms
 * @property float $tax_amt
 * @property float $freight_amt
 * @property string $invoice_date
 * @property string $ship_date
 * @property string $carrier
 * @property string $ship_via
 * @property string $customer_po
 * @property string $order_type
 * @property string $shipping_policy
 * @property string $date_created
 * @property string $date_modified
 * @property string $deleted_at
 * @property-read \Illuminate\Database\Eloquent\Collection|\Hilco\Models\OrderItem[] $items
 * @property-read \Illuminate\Database\Eloquent\Collection|\Hilco\Models\QueuedOrderMainLine[] $mainLines
 * @property-read mixed $affiliateSales
 * @property-read mixed $id_string
 * @method static \Illuminate\Database\Query\Builder|\Hilco\Models\QueuedOrder whereId($value)
 * @method static \Illuminate\Database\Query\Builder|\Hilco\Models\QueuedOrder whereDivisionId($value)
 * @method static \Illuminate\Database\Query\Builder|\Hilco\Models\QueuedOrder wherePlantId($value)
 * @method static \Illuminate\Database\Query\Builder|\Hilco\Models\QueuedOrder whereInvoiceNumber($value)
 * @method static \Illuminate\Database\Query\Builder|\Hilco\Models\QueuedOrder whereWebOrderNumber($value)
 * @method static \Illuminate\Database\Query\Builder|\Hilco\Models\QueuedOrder whereBilltoCustomersegmentId($value)
 * @method static \Illuminate\Database\Query\Builder|\Hilco\Models\QueuedOrder whereSoldtoCustomersegmentId($value)
 * @method static \Illuminate\Database\Query\Builder|\Hilco\Models\QueuedOrder whereFob($value)
 * @method static \Illuminate\Database\Query\Builder|\Hilco\Models\QueuedOrder wherePaymentTerms($value)
 * @method static \Illuminate\Database\Query\Builder|\Hilco\Models\QueuedOrder whereTaxAmt($value)
 * @method static \Illuminate\Database\Query\Builder|\Hilco\Models\QueuedOrder whereFreightAmt($value)
 * @method static \Illuminate\Database\Query\Builder|\Hilco\Models\QueuedOrder whereInvoiceDate($value)
 * @method static \Illuminate\Database\Query\Builder|\Hilco\Models\QueuedOrder whereShipDate($value)
 * @method static \Illuminate\Database\Query\Builder|\Hilco\Models\QueuedOrder whereCarrier($value)
 * @method static \Illuminate\Database\Query\Builder|\Hilco\Models\QueuedOrder whereShipVia($value)
 * @method static \Illuminate\Database\Query\Builder|\Hilco\Models\QueuedOrder whereCustomerPo($value)
 * @method static \Illuminate\Database\Query\Builder|\Hilco\Models\QueuedOrder whereOrderType($value)
 * @method static \Illuminate\Database\Query\Builder|\Hilco\Models\QueuedOrder whereShippingPolicy($value)
 * @method static \Illuminate\Database\Query\Builder|\Hilco\Models\QueuedOrder whereDateCreated($value)
 * @method static \Illuminate\Database\Query\Builder|\Hilco\Models\QueuedOrder whereDateModified($value)
 * @method static \Illuminate\Database\Query\Builder|\Hilco\Models\QueuedOrder whereDeletedAt($value)
 * @mixin \Eloquent
 * @property string $hilco_order_number
 * @property string $order_date
 * @property string $order_due_date
 * @property string $order_status
 * @property string $ship_policy
 * @property integer $salesordertype_id
 * @property string $ship_to_attention
 * @property integer $fob_id
 * @property integer $carrier_id
 * @property integer $paymentterm_id
 * @property string $order_instructions
 * @property string $currency_code
 * @property integer $salesrep_id
 * @property integer $billto_customer_id
 * @property integer $soldto_customer_id
 * @property string $shipping_line1
 * @property string $shipping_line2
 * @property string $shipping_line3
 * @property string $shipping_city
 * @property string $shipping_state
 * @property string $shipping_zip
 * @property string $shipping_country
 * @property string $comment_all
 * @property string $comment_external
 * @property string $comment_internal
 * @property string $comment_display
 * @property float $part_amount
 * @property float $misc_amount
 * @property float $part_discount
 * @property float $order_discount
 * @property float $freight_amount
 * @property float $tax_amount
 * @property float $ins_amount
 * @property float $order_amount
 * @property string $order_source
 * @property string $promo_code
 * @property string $state_license
 * @property string $plant
 * @property string $warehouse
 * @property string $bin_location
 * @property string $date_uploaded
 * @property integer $warehouse_id
 * @property integer $binlocation_id
 * @method static \Illuminate\Database\Query\Builder|\Hilco\Models\QueuedOrder whereHilcoOrderNumber($value)
 * @method static \Illuminate\Database\Query\Builder|\Hilco\Models\QueuedOrder whereOrderDate($value)
 * @method static \Illuminate\Database\Query\Builder|\Hilco\Models\QueuedOrder whereOrderDueDate($value)
 * @method static \Illuminate\Database\Query\Builder|\Hilco\Models\QueuedOrder whereOrderStatus($value)
 * @method static \Illuminate\Database\Query\Builder|\Hilco\Models\QueuedOrder whereShipPolicy($value)
 * @method static \Illuminate\Database\Query\Builder|\Hilco\Models\QueuedOrder whereSalesordertypeId($value)
 * @method static \Illuminate\Database\Query\Builder|\Hilco\Models\QueuedOrder whereShipToAttention($value)
 * @method static \Illuminate\Database\Query\Builder|\Hilco\Models\QueuedOrder whereFobId($value)
 * @method static \Illuminate\Database\Query\Builder|\Hilco\Models\QueuedOrder whereCarrierId($value)
 * @method static \Illuminate\Database\Query\Builder|\Hilco\Models\QueuedOrder wherePaymenttermId($value)
 * @method static \Illuminate\Database\Query\Builder|\Hilco\Models\QueuedOrder whereOrderInstructions($value)
 * @method static \Illuminate\Database\Query\Builder|\Hilco\Models\QueuedOrder whereCurrencyCode($value)
 * @method static \Illuminate\Database\Query\Builder|\Hilco\Models\QueuedOrder whereSalesrepId($value)
 * @method static \Illuminate\Database\Query\Builder|\Hilco\Models\QueuedOrder whereBilltoCustomerId($value)
 * @method static \Illuminate\Database\Query\Builder|\Hilco\Models\QueuedOrder whereSoldtoCustomerId($value)
 * @method static \Illuminate\Database\Query\Builder|\Hilco\Models\QueuedOrder whereShippingLine1($value)
 * @method static \Illuminate\Database\Query\Builder|\Hilco\Models\QueuedOrder whereShippingLine2($value)
 * @method static \Illuminate\Database\Query\Builder|\Hilco\Models\QueuedOrder whereShippingLine3($value)
 * @method static \Illuminate\Database\Query\Builder|\Hilco\Models\QueuedOrder whereShippingCity($value)
 * @method static \Illuminate\Database\Query\Builder|\Hilco\Models\QueuedOrder whereShippingState($value)
 * @method static \Illuminate\Database\Query\Builder|\Hilco\Models\QueuedOrder whereShippingZip($value)
 * @method static \Illuminate\Database\Query\Builder|\Hilco\Models\QueuedOrder whereShippingCountry($value)
 * @method static \Illuminate\Database\Query\Builder|\Hilco\Models\QueuedOrder whereCommentAll($value)
 * @method static \Illuminate\Database\Query\Builder|\Hilco\Models\QueuedOrder whereCommentExternal($value)
 * @method static \Illuminate\Database\Query\Builder|\Hilco\Models\QueuedOrder whereCommentInternal($value)
 * @method static \Illuminate\Database\Query\Builder|\Hilco\Models\QueuedOrder whereCommentDisplay($value)
 * @method static \Illuminate\Database\Query\Builder|\Hilco\Models\QueuedOrder wherePartAmount($value)
 * @method static \Illuminate\Database\Query\Builder|\Hilco\Models\QueuedOrder whereMiscAmount($value)
 * @method static \Illuminate\Database\Query\Builder|\Hilco\Models\QueuedOrder wherePartDiscount($value)
 * @method static \Illuminate\Database\Query\Builder|\Hilco\Models\QueuedOrder whereOrderDiscount($value)
 * @method static \Illuminate\Database\Query\Builder|\Hilco\Models\QueuedOrder whereFreightAmount($value)
 * @method static \Illuminate\Database\Query\Builder|\Hilco\Models\QueuedOrder whereTaxAmount($value)
 * @method static \Illuminate\Database\Query\Builder|\Hilco\Models\QueuedOrder whereInsAmount($value)
 * @method static \Illuminate\Database\Query\Builder|\Hilco\Models\QueuedOrder whereOrderAmount($value)
 * @method static \Illuminate\Database\Query\Builder|\Hilco\Models\QueuedOrder whereOrderSource($value)
 * @method static \Illuminate\Database\Query\Builder|\Hilco\Models\QueuedOrder whereStateLicense($value)
 * @method static \Illuminate\Database\Query\Builder|\Hilco\Models\QueuedOrder wherePlant($value)
 * @method static \Illuminate\Database\Query\Builder|\Hilco\Models\QueuedOrder whereWarehouse($value)
 * @method static \Illuminate\Database\Query\Builder|\Hilco\Models\QueuedOrder whereBinLocation($value)
 * @method static \Illuminate\Database\Query\Builder|\Hilco\Models\QueuedOrder whereDateUploaded($value)
 * @method static \Illuminate\Database\Query\Builder|\Hilco\Models\QueuedOrder whereWarehouseId($value)
 * @method static \Illuminate\Database\Query\Builder|\Hilco\Models\QueuedOrder whereBinlocationId($value)
 * @property-read \Hilco\Models\Division $division
 * @property-read \Illuminate\Database\Eloquent\Collection|\Hilco\Models\QueuedOrderMainLine[] $partLines
 * @property-read \Illuminate\Database\Eloquent\Collection|\Hilco\Models\QueuedOrderMainLine[] $miscLines
 * @property-read \Hilco\Models\Customer $soldToCustomer
 * @property-read \Hilco\Models\Customer $billToCustomer
 * @property-read \Hilco\Models\Plant $orderShipPlant
 * @property-read \Hilco\Models\Warehouse $orderShipWarehouse
 * @property-read \Hilco\Models\BinLocation $orderShipBinLocation
 * @property-read \Hilco\Models\Customer $customer
 * @property-read \Illuminate\Database\Eloquent\Collection|\Hilco\Models\QueuedOrderMainLine[] $orderParts
 * @property-read \Hilco\Models\SalesOrderType $salesOrderType
 */
class QueuedOrder extends WebModel
{
    protected $table = 'QueuedSalesOrders';

    public static $categories = [
        'overallsales' => '',
        'rxsales' => ['RX SAFETY'],
        'lenscaresales' => ['LC / BRANDING OTHER'],
        'consumersales' => ['ACCESSORIES OTHER'],
        'brandingsales' => ['LC / BRANDING OTHER'],
        'examinationsales' => ['EXAM SUPPLIES'],
        'customizationsales' => ['REPAIR PARTS OTHER'],
        'lowvisionsales' => ['RX SAFETY'],
        'dispensingsales' => ['LIQUID']

    ];

    public function fob() {
        return $this->belongsTo(FOB::class, "fob_id");
    }

    public function salesrep() {
        return $this->belongsTo(SalesRep::class, "salesrep_id");
    }

    public function orderedByUser() {
        return $this->belongsTo(WebUser::class, 'webuser_id', 'id');
    }

    public function approvedByUser() {
        return $this->belongsTo(WebUser::class, 'approver_webuser_id', 'id');
    }


    public function salesOrderType() {
        return $this->belongsTo(SalesOrderType::class, "salesordertype_id");
    }
    public function orderLineSchedules()
    {
        return $this->hasMany(SalesOrderLineSchedule::class, 'salesorder_id');
    }
    public function carrier() {
        return $this->belongsTo(Carrier::class, "carrier_id");
    }

    public function division() {
        return $this->belongsTo(Division::class, "division_id");
    }

    public function customer() {
        return $this->belongsTo(Customer::class, 'soldto_customer_id');
    }

    public function paymentTerms() {
        return $this->belongsTo(PaymentTerm::class, 'paymentterm_id', 'id');
    }

    public function partLines() {
        return $this->hasMany(QueuedOrderMainLine::class, 'salesorder_id')->where('parent_type', 'SalesOrderPartLines')->where('deleted_at', '=', '0000-00-00')->with('partLines.part');
    }

    public function miscLines() {
        return $this->hasMany(QueuedOrderMainLine::class, 'salesorder_id')->where('parent_type', 'SalesOrderMiscLines')->where('deleted_at', '=', '0000-00-00')->with('miscLines.miscCharge');
    }

    public function soldToCustomer() {
        return $this->belongsTo(Customer::class, "soldto_customer_id");
    }

    public function billToCustomer() {
        return $this->belongsTo(Customer::class, "billto_customer_id");
    }

    public function billToCustomerSegment() {
        $activeSegments = $this->billToCustomer->activeSegments;
        if ($activeSegments) {
            return $activeSegments->take(1);
        } else {
            return null;
        }
    }

    public function shipToAddress() {
        return $this->belongsTo(CustomerShippingAddress::class, "customershippingaddress_id");
    }

    public function orderShipPlant() {
        return $this->belongsTo(Plant::class, 'plant_id');
    }

    public function orderShipWarehouse() {
        return $this->belongsTo(Warehouse::class, 'warehouse_id');
    }

    public function orderShipBinLocation() {
        return $this->belongsTo(BinLocation::class, 'binlocation_id');
    }

    public function creditCardAuthorization() {
        return $this->hasMany(QueuedCreditCardAuthorization::class, 'salesorder_id');
    }

    public function comments() {

        $comments = array();
        if ($this->comment_all != null && $this->comment_all != '') {
            $comments['A'] = $this->comment_all;
        }
        if ($this->comment_external != null && $this->comment_external != '') {
            $comments['E'] = $this->comment_external;
        }
        if ($this->comment_internal != null && $this->comment_internal != '') {
            $comments['I'] = $this->comment_internal;
        }
        if ($this->comment_display != null && $this->comment_display != '') {
            $comments['D'] = $this->comment_display;
        }

        return $comments;
    }

    public function orderParts()
    {
        return $this->hasMany(QueuedOrderMainLine::class, 'salesorder_id')
            ->join('QueuedSalesOrderPartLines', 'QueuedSalesOrderMainLines.parent_id', '=', 'QueuedSalesOrderPartLines.id')
            ->join('Parts', 'QueuedSalesOrderPartLines.part_id', '=', 'Parts.id');
    }

    public function scopeSubmitted($query) {
        return $query->whereNotIn('order_status', ['UNSUBMITTED', 'DISCARDED', 'CANCELED', 'CANCELLED']);
    }

    public function scopeLastOrders($query, $soldToCustomerId, $take) {
        return $query
            ->where('soldto_customer_id', $soldToCustomerId)
            ->orderBy('order_date', 'desc')
            ->with('orderParts')
            ->take($take);
    }

    public function scopeDateBetween($query, $fromDate, $toDate = false) {
        if ($toDate === false) {
            $query->where('order_date', '>=', $fromDate);
        } else {
            $query->whereBetween('order_date', [$fromDate, $toDate]);
        }
        return $query;
    }

    public function getFriendlyOrderStatusAttribute() {
        return $this->friendlyStatus($this->order_status);
    }

    public static function friendlyStatus($status) {
        switch ($status) {
            case 'PENDING':
            case 'OPEN':
            case 'SENT_TO_POINTMAN':
                return 'Open';
            case 'CLOSED':
                return 'Closed';
            case 'PENDING_WEB':
                return 'Pending Approval';
        }
        return 'Open';
    }

    public function getTotalQuantityAttribute() {
        $qty = 0;
        $partLines = $this->partLines;
        if ($partLines) {
            $this->partLines->each(function ($mainLine) use (&$qty) {
                $partLine = $mainLine->partLine;
                if ($partLine) {
                    $qty += $mainLine->partLine->quantity;
                }
            });
        }

        return $qty;
    }

    public function getTotalShippedAttribute() {
        $qty = 0;
        $schedules = $this->orderLineSchedules;
        if ($schedules) {
            $this->orderLineSchedules->each(function ($lineSchedule) use (&$qty) {
                $qty += $lineSchedule->qty_shipped;
            });
        }

        return $qty;
    }

    public function getTrackingNumbersAttribute() {
        $numbers = [];
        foreach ($this->orderLineSchedules as $lineSchedule) {
            $numbers[$lineSchedule->shipment->tracking_number] = $lineSchedule->shipment->tracking_number;
        }
        return $numbers;
    }

    public function scopeToday($query) {
        return $query->where('order_date', Carbon::today()->toDateString());
    }

    public function scopeWebOrders($query) {
        return $query->where('order_origin', 'B2B');
    }

    public function scopeCstOrders($query) {
        return $query->where('hilco_order_number', 'RLIKE', '^[HUW]')->where(function ($where) {
            $where->whereNull('order_origin')->orWhere('order_origin', '!=', 'B2B');
        });
    }

    public function getApprovedAttribute() {
        return (bool) !($this->order_status == 'PENDING_WEB');
    }

    public function promotions() {
        return $this->belongsToMany(Promotion::class,
            'QueuedPromotion_SalesOrder',
            'salesorder_id',
            'promotion_id')
            ->wherePivot('applied', '=', 1);
    }

    public function priceListSalesOrder() {
        return $this->hasOne(QueuedPriceList_SalesOrder::class, 'salesorder_id');
    }
}