<?php

use Hilco\Models\WebAsset;
use Hilco\Models\WebCategory;
use Hilco\Models\WebCollection;
use Hilco\Models\WebFamily;
use Hilco\Models\WebGroup;
use Hilco\Models\WebLandingPage;
use Hilco\Models\WebPart;

if (! function_exists('webAssetUrl')) {
    function webAssetUrl($options) {
        return WebAsset::urlHelper($options);
    }
}

if (! function_exists('webLinkUrl')) {
    function webLinkUrl($options) {
        switch (array_get($options, 'type', 'url')) {
            case 'url':
                return array_get($options, 'target', '');
            case 'webLandingPage':
                return route('landingpage.slug', [array_get($options, 'target')]);
            case 'webAsset':
                return WebAsset::urlHelper(['id' => $options['target'], 'download' => true]);
        }
    }
}

if (! function_exists('webLinkTitle')) {
    function webLinkTitle($options) {
        $target = array_get($options, 'target', '');
        switch (array_get($options, 'type', 'url')) {
            case 'url':
                return $target;
            case 'webLandingPage':
                $webLandingPage = WebLandingPage::whereSlug($target)->first();
                return $webLandingPage ? $webLandingPage->name : '';
            case 'webAsset':
                $webAsset = WebAsset::find($target);
                return $webAsset ? $webAsset->name : '';
        }
    }
}

if (!function_exists('b2bLink')) {
    function b2bLink($model) {
        $url = config('hilco.b2b.url', false);
        if (!$url) return false;
        switch (get_class($model)) {
            case WebPart::class:
                return $url . '/f/' . $model->webFamily->slug;
            case WebFamily::class:
                return $url . '/f/' . $model->slug;
            case WebCollection::class:
                return $url . '/l/' . $model->slug;
            case WebCategory::class:
                return $url . '/c/' . $model->slug;
            case WebGroup::class:
                return $url . '/g/' . $model->slug;
            case WebLandingPage::class:
                return $url . '/lp/' . $model->slug;
        }
        return false;
    }
}

if (!function_exists('canUser')) {
    function canUser($permission) {
        $user = Auth::user();
        if (is_null($user)) return false;
        return $user->can($permission);
    }
}