<?php

namespace Hilco\Models;

use DB;

/**
 * Hilco\Models\FormFields
 *
 * @property integer $id
 * @property string $label
 * @property string $type
 * @property string $date_modified
 * @property string $deleted_at
 */
class FormFields extends WebModel
{
    protected $table = "FormFields";
    protected $fillable = ['label','type'];
    public static $types = [
        'text'     => 'Text Field',
        'textarea' => 'Textarea',
        'select'   => 'SelectBox',
        'checkbox' => 'Check Box',
        'radio'    => 'Radio Button',
        'tinyMce'  => 'TinyMce Editor',
    ];

    public function values() {
        return $this->hasMany(FormFieldValues::class, 'formfield_id', 'id');  
    }

}
