<?php

namespace Hilco\Models;

use DB;

use Hilco\Models\SelectsRelatedCount;
use Illuminate\Database\Eloquent\Relations\HasOne;

class WebProductMenuConfiguration extends WebModel
{
    protected $table = 'WebProductMenuConfigurations';
    protected $fillable = ['product_id', 'product_type', 'header_color', 'top_content_type', 'top_content_id', 'bottom_content_type', 'bottom_content_id'];

    public function getIcon()
    {
        $asset = $this->assetsByType('icon')->first();
        return $asset;
    }

    public function iconImage($width = false, $height = false)
    {
        $asset = $this->getIcon();
        if ($height === false && is_string($width)) return WebAsset::getPredefinedSizeUrl($asset, $width);
        return WebAsset::getSizedUrl($asset, $width, $height);
    }

    public function topWebAsset()
    {
        if ($this->top_content_type == 'webAsset') {
            return $this->hasOne(WebAsset::class, 'id', 'top_content_id');
        } else {
            $webAsset = new WebAsset();
            $webProductionMenuConfiguration = new WebProductMenuConfiguration();
            return new HasOne($webAsset->newQuery(), $webProductionMenuConfiguration, 'WebAssets.id', 'top_content_id');
        }
    }

    public function topWebFamily()
    {
        if ($this->top_content_type == 'webFamily') {
            return $this->hasOne(WebFamily::class, 'id', 'top_content_id');
        } else {
            $webFamily = new WebFamily();
            $webProductionMenuConfiguration = new WebProductMenuConfiguration();
            return new HasOne($webFamily->newQuery(), $webProductionMenuConfiguration, 'WebFamilies.id', 'top_content_id');
        }
    }

    public function getTopBestSeller()
    {
        if ($this->top_content_type == 'bestSeller' && $this->product_type == 'webGroup') {
            $webgroup = WebGroup::find($this->product_id);
            if ($webgroup != null) {
                return WebFamily::webVisible()->bestSellers()->inGroup($webgroup)->with('visibleWebParts')->with('visibleWebParts.part.prices')->first();
            }
        }
        return null;
    }

    public function bottomWebAsset()
    {
        if ($this->bottom_content_type == 'webAsset') {
            return $this->hasOne(WebAsset::class, 'id', 'bottom_content_id');
        } else {
            $webAsset = new WebAsset();
            $webProductionMenuConfiguration = new WebProductMenuConfiguration();
            return new HasOne($webAsset->newQuery(), $webProductionMenuConfiguration, 'WebAssets.id', 'bottom_content_id');
        }
    }

    public function bottomWebFamily()
    {
        if ($this->bottom_content_type == 'webFamily') {
            return $this->hasOne(WebFamily::class, 'id', 'bottom_content_id');
        } else {
            $webFamily = new WebFamily();
            $webProductionMenuConfiguration = new WebProductMenuConfiguration();
            return new HasOne($webFamily->newQuery(), $webProductionMenuConfiguration, 'WebFamilies.id', 'bottom_content_id');
        }
    }

    public function getBottomBestSeller()
    {
        if ($this->bottom_content_type == 'bestSeller' && $this->product_type == 'webGroup') {
            $webgroup = WebGroup::find('product_id');
            if ($webgroup != null) {
                return $webgroup->webCategories->webCollections->webFamilies->webVisible()->bestSellers()->with('visibleWebParts')->with('visibleWebParts.part.prices')->first();
            }
        }
        return null;
    }

    public function getTopLink()
    {
        $link = array('type' => $this->top_link_type, 'target' => $this->top_link_target);
        return $link;
    }

    public function getBottomLink()
    {
        $link = array('type' => $this->bottom_link_type, 'target' => $this->bottom_link_target);
        return $link;
    }

    use HasAssets;
}