<?php
/**
 * Created by PhpStorm.
 * User: Ben
 * Date: 11/4/2016
 * Time: 1:44 PM
 */

namespace Hilco;

use DB;
use RocketShipIt\Rate;
use RocketShipIt\TimeInTransit;

class RateShop {
    function rateShopCanada($hilcoCarrierGroupCode, $shipmentArray) {
        $shipVia = [];
        foreach ($shipmentArray as $shipment) {
            $shipViaTemp = [];
            $shipViaTemp = array_merge($shipViaTemp, RateShop::rateShopCanadaFedex($hilcoCarrierGroupCode, $shipment['weight'], $shipment['volume'], $shipment['toCode'], $shipment['fromCode']));
            $shipViaTemp = array_merge($shipViaTemp, RateShop::rateShopCanadaPost($hilcoCarrierGroupCode, $shipment['weight'], $shipment['volume'], $shipment['toCode'], $shipment['fromCode']));
            $shipViaTemp = array_merge($shipViaTemp, RateShop::rateShopCanadaICS($hilcoCarrierGroupCode, $shipment['weight'], $shipment['volume'], $shipment['toCode'], $shipment['fromCode']));

            foreach ($shipViaTemp as $key => $value) {
                if (!isset($shipVia[$key])) {
                    $shipVia[$key] = $value;
                    $shipVia[$key]['count'] = 0;
                } else {
                    $shipVia[$key]['rate'] += $value['rate'];
                }
                $shipVia[$key]['count']++;
            }
        }

        foreach ($shipVia as $key => $value) {
            if ($value['count'] != count($shipmentArray)) {
                unset($shipVia[$key]);
            } else {
                $shipVia[$key]['rate'] += 2;
            }
        }

        return $shipVia;
    }

    private function rateShopCanadaFedex($hilcoCarrierGroupCode, $weight, $volume, $toCode, $fromCode) {
        $data = [];

        $dbResult = DB::connection()
            ->table('RateShopAPIDetails')
            ->join('RateShopGroups', 'RateShopAPIDetails.hilco_carrier_code', '=', 'RateShopGroups.hilco_carrier_code')
            ->join('Carriers', 'Carriers.carrier_code', '=', 'RateShopAPIDetails.hilco_carrier_code')
            ->where('group_code', $hilcoCarrierGroupCode)
            ->where('api_carrier', '=', 'fedex')
            ->where('RateShopGroups.deleted_at', '=', '0000-00-00 00:00:00')
            ->select(['RateShopAPIDetails.*', 'Carriers.carrier_desc'])
            ->get();
        $dbResult = json_decode(json_encode($dbResult), true);

        foreach ($dbResult as $row) {
            $data[$row['api_carrier']][$row['residential']][] = $row;
        }

        $returnData = [];
        foreach ($data as $apiCarrier => $array1) {
            foreach ($array1 as $residential => $carrierCodeArray) {
                $rate = new Rate($apiCarrier);

                $rate->setParameter("accountNumber", '279677994');

                $rate->setParameter('shipCountry', 'US');
                $rate->setParameter('toCountry', 'CA');

                $rate->setParameter('weightUnit', 'LBS');
                $rate->setParameter('weight', $weight >= 0.01 ? $weight : 0.01);

                $rate->setParameter('lengthUnit', 'IN');
                $cubedVolume = ceil(pow($volume * 1.1, 1 / 3));
                $rate->setParameter('width', $cubedVolume);
                $rate->setParameter('length', $cubedVolume);
                $rate->setParameter('height', $cubedVolume);

                $rate->setParameter('currency', 'CAD');
                $rate->setParameter('shipCode', $fromCode);

                $rate->setParameter('toCode', $toCode);

                $rate->setParameter('residentialAddressIndicator', $residential);

                $rateResponse = $rate->getAllRates();

                $transit = new TimeInTransit($apiCarrier);

                $transit->setParameter('shipCountry', 'US');
                $transit->setParameter('shipCode', $fromCode);

                $transit->setParameter('toCountry', 'CA');
                $transit->setParameter('toCode', $toCode);

                $transit->setParameter('weightUnit', 'LBS');
                $transit->setParameter('weight', $weight);
                $transit->setParameter('saturdayDelivery', 'YES');

                $transit->setParameter('lengthUnit', 'IN');
                $cubedVolume = ceil(pow($volume * 1.1, 1 / 3));
                $transit->setParameter('width', $cubedVolume);
                $transit->setParameter('length', $cubedVolume);
                $transit->setParameter('height', $cubedVolume);

                $transit->setParameter('pickupDate', date('Y-m-d'));

                $transitResponse = $transit->getTimeInTransit();

                foreach ($carrierCodeArray as $carrierCode) {
                    $api_code = $carrierCode['api_code'];
                    $carrier_desc = $carrierCode['carrier_desc'];
                    $hilco_carrier_code = $carrierCode['hilco_carrier_code'];
                    $transit_code = $carrierCode['transit_code'];
                    $discount = $carrierCode['discount'] / 100;

                    $returnData[$hilco_carrier_code] = [
                        'api_carrier' => $apiCarrier,
                        'residential' => $residential,
                        'hilco_carrier_code' => $hilco_carrier_code,
                        'carrier_desc' => $carrier_desc,
                        'rate' => null,
                        'service' => $api_code,
                        'delivery_date' => null,
                        'delivery_time' => null,
                        'guaranteed' => null
                    ];

                    if ($apiCarrier == 'fedex') {
                        if (isset($rateResponse['RateReply']['RateReplyDetails'])) {
                            foreach ($rateResponse['RateReply']['RateReplyDetails'] as $rateReplyDetails) {
                                if (isset($rateReplyDetails['ServiceType']) && $api_code == $rateReplyDetails['ServiceType']) {
                                    $returnData[$hilco_carrier_code] = array_merge($returnData[$hilco_carrier_code],
                                        [
                                            'rate' => $rateReplyDetails['RatedShipmentDetails'][0]['ShipmentRateDetail']['TotalNetFreight']['Amount'] * (1 - $discount),
                                        ]);
                                    if (isset($rateReplyDetails['CommitDetails']['CommitTimestamp'])) {
                                        $returnData[$hilco_carrier_code] = array_merge($returnData[$hilco_carrier_code],
                                            [
                                                'delivery_date' => date('Y-m-d', strtotime($rateReplyDetails['CommitDetails']['CommitTimestamp'])),
                                                'delivery_time' => date('H:i', strtotime($rateReplyDetails['CommitDetails']['CommitTimestamp'])),
                                                'guaranteed' => "Y"
                                            ]);
                                    } else {
                                        $returnData[$hilco_carrier_code] = array_merge($returnData[$hilco_carrier_code],
                                            [
                                                'delivery_date' => date('Y-m-d', strtotime("+ 5 weekdays")),
                                                'guaranteed' => "Y"
                                            ]);
                                    }
                                }
                            }
                        }
                    }
                }
            }
        }

        return $returnData;
    }

    private function rateShopCanadaPost($hilcoCarrierGroupCode, $weight, $volume, $toCode, $fromCode)
    {
        $rate = new Rate('canada');

        $rate->setParameter('shipCountry', 'CA');
        $rate->setParameter('toCountry', 'CA');

        $rate->setParameter('weightUnit', 'LBS');
        $rate->setParameter('weight', $weight >= 0.01 ? $weight : 0.01);

        $rate->setParameter('lengthUnit', 'IN');
        $rate->setParameter('volume', $volume);

        $rate->setParameter('currency', 'USD');
        $rate->setParameter('shipCode', $fromCode);
        $rate->setParameter('toCode', $toCode);

        $rateResponse = $rate->getAllRates();

        $dbResult = DB::connection()
            ->table('RateShopAPIDetails')
            ->join('RateShopGroups', 'RateShopAPIDetails.hilco_carrier_code', '=', 'RateShopGroups.hilco_carrier_code')
            ->join('Carriers', 'Carriers.carrier_code', '=', 'RateShopAPIDetails.hilco_carrier_code')
            ->where('group_code', $hilcoCarrierGroupCode)
            ->where('api_carrier', '!=', 'ICS')
            ->where('api_carrier', '!=', 'fedex')
            ->where('RateShopGroups.deleted_at', '=', '0000-00-00 00:00:00')
            ->select(['RateShopAPIDetails.*', 'Carriers.carrier_desc'])
            ->get();
        $dbResult = json_decode(json_encode($dbResult), true);

        $returnData = [];
        foreach ($dbResult as $row) {
            $apiCarrier = $row['api_carrier'];
            $residential = $row['residential'];
            $api_code = $row['api_code'];
            $carrier_desc = $row['carrier_desc'];
            $hilco_carrier_code = $row['hilco_carrier_code'];
            $discount = $row['discount'] / 100;

            $returnData[$hilco_carrier_code] = [
                'api_carrier' => $apiCarrier,
                'residential' => $residential,
                'hilco_carrier_code' => $hilco_carrier_code,
                'carrier_desc' => $carrier_desc,
                'rate' => null,
                'service' => $api_code,
                'delivery_date' => null,
                'delivery_time' => null,
                'guaranteed' => null
            ];

            if (isset($rateResponse['price-quotes']['price-quote'])) {
                foreach ($rateResponse['price-quotes']['price-quote'] as $priceQuote) {
                    if (isset($priceQuote['service-code']) && isset($priceQuote['price-details']['base']) && $priceQuote['service-code'] === $api_code) {
                        $returnData[$hilco_carrier_code]['rate'] = $priceQuote['price-details']['base'];
                        if (isset($priceQuote['price-details']['adjustments']['adjustment'])) {
                            foreach ($priceQuote['price-details']['adjustments']['adjustment'] as $adjustment) {
                                if (isset($adjustment['adjustment-cost']) && $adjustment['adjustment-cost'] > 0) {
                                    $returnData[$hilco_carrier_code]['rate'] += $adjustment['adjustment-cost'];
                                }
                            }
                        }
                    }
                }
            }
        }

        return $returnData;
    }

    private function rateShopCanadaICS($hilcoCarrierGroupCode, $weight, $volume, $toCode, $fromCode) {
        $soapUrl = config('hilco.ics.apiEndpoint');

        $soapUser = config('hilco.ics.apiUsername');
        $soapPassword = config('hilco.ics.apiPassword');

        $dbResult = DB::connection()
            ->table('RateShopAPIDetails')
            ->join('RateShopGroups', 'RateShopAPIDetails.hilco_carrier_code', '=', 'RateShopGroups.hilco_carrier_code')
            ->join('Carriers', 'Carriers.carrier_code', '=', 'RateShopAPIDetails.hilco_carrier_code')
            ->where('group_code', $hilcoCarrierGroupCode)
            ->where('api_carrier', 'ICS')
            ->where('RateShopGroups.deleted_at', '=', '0000-00-00 00:00:00')
            ->select(['RateShopAPIDetails.*', 'Carriers.carrier_desc'])
            ->get();
        $dbResult = json_decode(json_encode($dbResult), true);

        $returnData = [];
        foreach ($dbResult as $row) {
            $apiCarrier = $row['api_carrier'];
            $residential = $row['residential'];
            $api_code = $row['api_code'];
            $carrier_desc = $row['carrier_desc'];
            $hilco_carrier_code = $row['hilco_carrier_code'];
            $discount = $row['discount'] / 100;

            $cubedVolume = ceil(pow($volume * 1.1, 1/3));

            $xml_post_string = <<<XMLEND
<?xml version="1.0" encoding="utf-8"?>
<soap12:Envelope xmlns:xsi="http://www.w3.org/2001/XMLSchema-instance" xmlns:xsd="http://www.w3.org/2001/XMLSchema" xmlns:soap12="http://www.w3.org/2003/05/soap-envelope">
  <soap12:Body>
    <GetEstimatedCharges xmlns="http://www.icscourier.ca/">
      <AuthenicateAccount>
        <AccountID>$soapUser</AccountID>
        <Password>$soapPassword</Password>
      </AuthenicateAccount>
      <PkgInfo>
        <Product>$api_code</Product>
        <Pieces>
          <PieceInfo>
            <Weight>$weight</Weight>
            <Length>$cubedVolume</Length>
            <Width>$cubedVolume</Width>
            <Height>$cubedVolume</Height>
          </PieceInfo>
        </Pieces>
        <FromPost>$fromCode</FromPost>
        <ToPost>$toCode</ToPost>
      </PkgInfo>
    </GetEstimatedCharges>
  </soap12:Body>
</soap12:Envelope>
XMLEND;


            $headers = array(
                "POST /ICSAPIcnsWebService/service.asmx HTTP/1.1",
                "Host: www1.ics-canada.net",
                "Content-type: application/soap+xml;charset=\"utf-8\"",
                "Content-Length: " . strlen($xml_post_string),
            );

            $url = $soapUrl;

            // PHP cURL  for https connection with auth
            $ch = curl_init();
            curl_setopt($ch, CURLOPT_URL, $url);
            curl_setopt($ch, CURLOPT_RETURNTRANSFER, true);
            curl_setopt($ch, CURLOPT_POST, true);
            curl_setopt($ch, CURLOPT_POSTFIELDS, $xml_post_string);
            curl_setopt($ch, CURLOPT_HTTPHEADER, $headers);
            curl_setopt($ch, CURLOPT_CONNECTTIMEOUT, 3);

            // converting
            $response = curl_exec($ch);
            if ($response === false) {
                $returnData[$hilco_carrier_code] = [
                    'api_carrier' => $apiCarrier,
                    'residential' => $residential,
                    'hilco_carrier_code' => $hilco_carrier_code,
                    'carrier_desc' => $carrier_desc,
                    'rate' => -9999,
                    'service' => $api_code,
                    'delivery_date' => null,
                    'delivery_time' => null,
                    'guaranteed' => null
                ];
            }
            curl_close($ch);

            // converting
            $response1 = str_replace("<soap:Body>", "", $response);
            $response2 = str_replace("</soap:Body>", "", $response1);

            // converting to XML
            $parser = simplexml_load_string($response2);

            if (isset($parser->GetEstimatedChargesResponse->GetEstimatedChargesResult->BaseCharges)) {
                $charge = (string)$parser->GetEstimatedChargesResponse->GetEstimatedChargesResult->BaseCharges;
                if ($charge > 0) {
                    $returnData[$hilco_carrier_code] = [
                        'api_carrier' => $apiCarrier,
                        'residential' => $residential,
                        'hilco_carrier_code' => $hilco_carrier_code,
                        'carrier_desc' => $carrier_desc,
                        'rate' => $charge * (1 - $discount),
                        'service' => $api_code,
                        'delivery_date' => null,
                        'delivery_time' => null,
                        'guaranteed' => null
                    ];
                }
            }
        }

        return $returnData;
    }

    function rateShopUSAWithAccount($carrierCodes, $weight, $volume, $toState, $toCode, $fromCode)
    {
        $data = [];
        $dbResult = DB::connection()
            ->table('RateShopAPIDetails')
            ->join('Carriers', 'Carriers.carrier_code', '=', 'RateShopAPIDetails.hilco_carrier_code')
            ->whereIn('RateShopAPIDetails.hilco_carrier_code', $carrierCodes)
            ->select(['RateShopAPIDetails.*', 'Carriers.carrier_desc'])
            ->get();
        $dbResult = json_decode(json_encode($dbResult), true);
        foreach ($dbResult as $row) {
            $data[$row['api_carrier']][$row['residential']][] = $row;
        }

        $returnData = $this->rateShopUSAWithData($data, $weight, $volume, $toCode, $fromCode);

        foreach ($returnData as $hilco_carrier_code => $data) {
            if (isset($data['rate'])) {
                $returnData[$hilco_carrier_code]['rate'] += 2;
            }
        }
        return $returnData;
    }

    function rateShopUSA($hilcoCarrierGroupCode, $weight, $volume, $toCode, $fromCode)
    {
        $data = [];
        $dbResult = DB::connection()
            ->table('RateShopAPIDetails')
            ->join('RateShopGroups', 'RateShopAPIDetails.hilco_carrier_code', '=', 'RateShopGroups.hilco_carrier_code')
            ->join('Carriers', 'Carriers.carrier_code', '=', 'RateShopAPIDetails.hilco_carrier_code')
            ->where('group_code', '=', $hilcoCarrierGroupCode)
            ->select(['RateShopAPIDetails.*', 'Carriers.carrier_desc'])
            ->get();
        $dbResult = json_decode(json_encode($dbResult), true);
        foreach ($dbResult as $row) {
            $data[$row['api_carrier']][$row['residential']][] = $row;
        }

        $returnData = $this->rateShopUSAWithData($data, $weight, $volume, $toCode, $fromCode);

        foreach ($returnData as $hilco_carrier_code=>$data) {
            if (isset($data['rate'])) {
                $returnData[$hilco_carrier_code]['rate'] += 2;
            }
        }

        return $returnData;
    }

    private function rateShopUSAWithData($data, $weight, $volume, $toCode, $fromCode) {
        $returnData = [];
        foreach ($data as $apiCarrier => $array1) {
            foreach ($array1 as $residential => $carrierCodeArray) {
                $rate = new Rate($apiCarrier);

                if ($apiCarrier == 'USPS') {
                    $toCode = substr($toCode, 0, 5);
                }
                
                $rate->setParameter("accountNumber", '065355');

                $rate->setParameter('shipCountry', 'US');
                $rate->setParameter('toCountry', 'US');

                $rate->setParameter('weightUnit', 'LBS');
                $rate->setParameter('weight', $weight >= 0.01 ? $weight : 0.01);

                $rate->setParameter('lengthUnit', 'IN');
//                $rate->setParameter('volume', $volume);
                $cubedVolume = ceil(pow($volume * 1.1, 1/3));
                $rate->setParameter('width', $cubedVolume);
                $rate->setParameter('length', $cubedVolume);
                $rate->setParameter('height', $cubedVolume);

                $rate->setParameter('currency', 'USD');
                $rate->setParameter('shipCode', $fromCode);

                $rate->setParameter('toCode', $toCode);

                $rate->setParameter('residentialAddressIndicator', $residential);

                $rateResponse = $rate->getAllRates();


                $transit = new TimeInTransit($apiCarrier);

                $transit->setParameter('shipCountry', 'US');
                $transit->setParameter('shipCode', $fromCode);

                $transit->setParameter('toCountry', 'US');
                $transit->setParameter('toCode', $toCode);

                $transit->setParameter('weightUnit', 'LBS');
                $transit->setParameter('weight', $weight);
                $transit->setParameter('saturdayDelivery', 'YES');

                $transit->setParameter('lengthUnit', 'IN');
//                $transit->setParameter('volume', $volume);
                $cubedVolume = ceil(pow($volume * 1.1, 1/3));
                $transit->setParameter('width', $cubedVolume);
                $transit->setParameter('length', $cubedVolume);
                $transit->setParameter('height', $cubedVolume);

                $transit->setParameter('pickupDate', date('Y-m-d'));

                $transitResponse = $transit->getTimeInTransit();

                foreach ($carrierCodeArray as $carrierCode) {
                    $api_code = $carrierCode['api_code'];
                    $carrier_desc = $carrierCode['carrier_desc'];
                    $hilco_carrier_code = $carrierCode['hilco_carrier_code'];
                    $transit_code = $carrierCode['transit_code'];
                    $discount = $carrierCode['discount'] / 100;

                    $returnData[$hilco_carrier_code] = [
                        'api_carrier' => $apiCarrier,
                        'residential' => $residential,
                        'hilco_carrier_code' => $hilco_carrier_code,
                        'carrier_desc' => $carrier_desc,
                        'rate' => null,
                        'service' => null,
                        'delivery_date' => null,
                        'delivery_time' => null,
                        'guaranteed' => null
                    ];

                    if ($apiCarrier == 'UPS') {
                        if (isset($rateResponse['RatingServiceSelectionResponse']['RatedShipment'])) {
                            foreach ($rateResponse['RatingServiceSelectionResponse']['RatedShipment'] as $ratedShipment) {
                                if ($api_code == $ratedShipment['Service']['Code']) {
                                    $returnData[$hilco_carrier_code] = array_merge($returnData[$hilco_carrier_code],
                                        [
                                            'rate' => $ratedShipment['TotalCharges']['MonetaryValue'] * (1 - $discount),
                                            'service' => $transit_code
                                        ]);
                                }
                            }
                            foreach ($transitResponse['TimeInTransitResponse']['TransitResponse']['ServiceSummary'] as $transitServices) {
                                if ($transit_code == $transitServices['Service']['Code']) {
                                    $returnData[$hilco_carrier_code] = array_merge($returnData[$hilco_carrier_code],
                                        [
                                            'delivery_date' => date('Y-m-d', strtotime($transitServices['EstimatedArrival']['Date'])),
                                            'delivery_time' => date('H:i', strtotime($transitServices['EstimatedArrival']['Time'])),
                                            'guaranteed' => $transitServices['Guaranteed']['Code']
                                        ]);
                                }
                            }
                        }
                    } else if ($apiCarrier == 'USPS') {
                        if (isset($rateResponse['RateV4Response']['Package']['Postage'])) {
                            foreach ($rateResponse['RateV4Response']['Package']['Postage'] as $postage) {
                                if ($api_code == $postage['CLASSID']) {
                                    $returnData[$hilco_carrier_code] = array_merge($returnData[$hilco_carrier_code],
                                        [
                                            'rate' => $postage['Rate'] * (1 - $discount)
                                        ]);
                                }
                            }
                            foreach ($transitResponse as $transitCodeKey => $transitServices) {
                                if ($transit_code == $transitCodeKey) {
                                    if ($transit_code != 'ExpressMailCommitmentResponse') {
                                        $returnData[$hilco_carrier_code] = array_merge($returnData[$hilco_carrier_code],
                                            [
                                                'delivery_date' => date('Y-m-d', strtotime("+ $transitServices[Days] weekdays")),
                                                'delivery_time' => null,
                                                'guaranteed' => "N"
                                            ]);
                                    } else {
                                        if (array_key_exists(0, $transitServices['Commitment'])) {
                                            $commitment = $transitServices['Commitment'][0];
                                        } else {
                                            $commitment = $transitServices['Commitment'];
                                        }
                                        $returnData[$hilco_carrier_code] = array_merge($returnData[$hilco_carrier_code],
                                            [
                                                'delivery_date' => date('Y-m-d', strtotime("+ " . str_replace("-", " ", $commitment['CommitmentName']))),
                                                'delivery_time' => date('H:i', strtotime($commitment['CommitmentTime'])),
                                                'guaranteed' => "Y"
                                            ]);
                                    }
                                }
                            }
                        }
                    } else if ($apiCarrier == 'fedex') {
                        if (isset($rateResponse['RateReply']['RateReplyDetails'])) {
                            foreach ($rateResponse['RateReply']['RateReplyDetails'] as $rateReplyDetails) {
                                if (isset($rateReplyDetails['ServiceType']) && $api_code == $rateReplyDetails['ServiceType']) {
                                    $returnData[$hilco_carrier_code] = array_merge($returnData[$hilco_carrier_code],
                                        [
                                            'rate' => $rateReplyDetails['RatedShipmentDetails'][0]['ShipmentRateDetail']['TotalNetFreight']['Amount'] * (1 - $discount),
                                        ]);
                                    if (isset($rateReplyDetails['CommitDetails']['CommitTimestamp'])) {
                                        $returnData[$hilco_carrier_code] = array_merge($returnData[$hilco_carrier_code],
                                            [
                                                'delivery_date' => date('Y-m-d', strtotime($rateReplyDetails['CommitDetails']['CommitTimestamp'])),
                                                'delivery_time' => date('H:i', strtotime($rateReplyDetails['CommitDetails']['CommitTimestamp'])),
                                                'guaranteed' => "Y"
                                            ]);
                                    } else {
                                        $returnData[$hilco_carrier_code] = array_merge($returnData[$hilco_carrier_code],
                                            [
                                                'delivery_date' => date('Y-m-d', strtotime("+ 5 weekdays")),
                                                'guaranteed' => "Y"
                                            ]);
                                    }
                                }
                            }
                        }
                    }
                }
            }
        }

        return $returnData;
    }
}