<?php

namespace Hilco;

use Carbon\Carbon;
use Hilco\Models\Customer;
use Hilco\Models\CroakiesAdventuresFamilies;
use Hilco\Models\CroakiesAdventuresPrepackPart;
use Hilco\Models\CroakiesAdventuresTiers;

/**
 * @deprecated defunct integration, Hilco no longer supports or requires Croakies "tier tracking"
 */
class CroakiesHelper
{

    protected function customer() {
        return b2b()->activeCustomer();
    }

    public function getPriceListToUse($webCartItems) {
        return "Catalog";
        $customer = $this->customer();
        if ($customer && $customer->activeSegment) {
            $billToCustomer = $customer->getBillToCustomerAttribute();
            $priceList = $billToCustomer->getDefaultPriceListAttribute();

            $priceListMap = config('croakiesadventures.priceListRanges');
            $tierMap = config('croakiesadventures.tierMap');

            if (\Illuminate\Support\Arr::get($priceListMap, $priceList)) {

                $totalCroakiesQtyOnOrder = $this->getTotalCroakiesPartLineQty($webCartItems);

                if ($totalCroakiesQtyOnOrder >= 36) {

                    $croakiesOrderedInPastYear = $billToCustomer->getCroakiesOrdered();
                    $croakiesAdventuresTier = $billToCustomer->croakiesAdventuresTier;

                    $unitsToCheck = $totalCroakiesQtyOnOrder + $croakiesOrderedInPastYear;
                    $calculatedPriceList = null;

                    foreach ($priceListMap as $tier => $range) {
                        $min = $range[0];
                        $max = $range[1];
                        if ($unitsToCheck >= $min) {
                            if ($max == -1 || $unitsToCheck <= $max) {
                                $calculatedPriceList = $tier;
                            }
                        }
                    }

                    if ($calculatedPriceList) {
                        if ($croakiesAdventuresTier &&
                            $tierMap[$calculatedPriceList] <= $croakiesAdventuresTier->tier) {
                            $priceList = array_search($croakiesAdventuresTier->tier, $tierMap);
                        } else {
                            $priceList = $calculatedPriceList;
                        }
                    }
                }
                return $priceList;
            }
            return null;
        } else {
            return null;
        }
    }

    public function getAllCroakiesItems($webCartItems) {
        $croakiesItems = collect();
        foreach ($webCartItems as $cartItem) {
            $part = $cartItem->webpart->part;
            $croakiesAdventuresFamilies = CroakiesAdventuresFamilies::where('product_family_no', '=', $part->product_family_no)->get();
            if ($croakiesAdventuresFamilies->count()) {
                $croakiesItems->push($cartItem);
            }
        }
        return $croakiesItems;
    }

    public function getTotalCroakiesPartLineQty($webCartItems) {
        $croakiesItems = $this->getAllCroakiesItems($webCartItems);
        $numCroakiesParts = 0;

        foreach ($croakiesItems as $croakiesItem) {
            $part = $croakiesItem->webpart->part;
            $croakiesAdventuresPrepackParts = CroakiesAdventuresPrepackPart::where('part_no', '=', $part->part_no)->get();
            if ($croakiesAdventuresPrepackParts->count()) {
                $numCroakiesParts += $croakiesItem->quantity * $croakiesAdventuresPrepackParts[0]->no_units;
            } else {
                $numCroakiesParts += $croakiesItem->quantity;
            }
        }

        return $numCroakiesParts;
    }

    public function tierOverride($customer, $newPriceList, $reason = 'orderUpgrade') {
        $tierMap = config('croakiesadventures.tierMap');
        $newTierLevel = \Illuminate\Support\Arr::get($tierMap, $newPriceList, 0);
        if ($newTierLevel > 0) {
            $currentTier = $customer->croakiesAdventuresTier;
            if ($currentTier && $newTierLevel > $currentTier->tier) {
                $newTier = new CroakiesAdventuresTiers();
                $newTier->id = generateUUID();
                $newTier->customer_id = $customer->id;
                $newTier->first_qualified_date = Carbon::now()->toDateString();
                $newTier->latest_qualified_date = Carbon::now()->toDateString();
                $newTier->tier = $newTierLevel;
                $newTier->upgrade_reason = $reason;
                $newTier->save();
            }
        }
    }

    public function isCroakiesPriceList($priceList) {
        $priceListMap = config('croakiesadventures.priceListRanges');
        return isset($priceListMap[$priceList]);
    }

}