<?php

namespace Hilco\Models;
use Illuminate\Database\Eloquent\Collection;
use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\Relations\BelongsTo;
use Illuminate\Database\Eloquent\Relations\HasMany;
use Illuminate\Database\Query\Builder;

/**
 * Hilco\Models\ProductCategoryGroup
 *
 * @property mixed $id
 * @property string $product_category_group
 * @property integer $productcategorysummary_id
 * @property string $productcategorygroup_description
 * @property string $date_created
 * @property string $date_modified
 * @property string $deleted_at
 * @property-read ProductCategorySummaries $categorySummary
 * @property-read ProductCategory $category
 * @property-read WebGroup $details
 * @property-read mixed $id_string
 * @method static Builder|ProductCategoryGroup whereId($value)
 * @method static Builder|ProductCategoryGroup whereProductCategoryGroup($value)
 * @method static Builder|ProductCategoryGroup whereProductcategorysummaryId($value)
 * @method static Builder|ProductCategoryGroup whereDateCreated($value)
 * @method static Builder|ProductCategoryGroup whereDateModified($value)
 * @method static Builder|ProductCategoryGroup whereDeletedAt($value)
 * @mixin \Eloquent
 * @property string $date_uploaded
 * @property-read Collection|ProductCategory[] $categories
 * @method static Builder|ProductCategoryGroup whereDateUploaded($value)
 */
class ProductCategoryGroup extends Model {
	protected $table = 'ProductCategoryGroups';
	protected $appends = ['shortName'];

	const TOTAL_ADJUST = "TOTAL ADJUST";

	/**
	 * @return BelongsTo
	 */
	public function categorySummary(): BelongsTo {
		return $this->belongsTo(ProductCategorySummaries::class, 'productcategorysummary_id', 'id');
	}

	/**
	 * @return HasMany
	 */
	public function categories(): HasMany {
		return $this->hasMany(ProductCategory::class, 'productcategorygroup_id', 'id');
	}

    /**
     * @return HasMany
     */
	public function productCategories(): HasMany {
        return $this->hasMany(ProductCategory::class, 'productcategorygroup_id', 'id');
    }

	public function getNameAttribute() {
	    return $this->product_category_group;
    }

    public function getShortNameAttribute() {
	    return transDefault("dashboard.spending.shortProductCategoryGroups." . $this->product_category_group, $this->product_category_group);
    }

    public function getDescription(): string {
        return $this->productcategorygroup_description;
    }
}
