<?php

namespace Hilco\Models;
use Illuminate\Database\Eloquent\Model;

/**
 * Hilco\Models\CustomerSalesStats
 *
 * @property integer $id
 * @property integer $customer_id
 * @property string $group_name
 * @property float $amount
 *
 * @mixin \Eloquent
 */
class CustomerSalesStats extends Model
{
    protected $table = 'CustomerSalesStats';
    const CREATED_AT = 'date_created';
    const UPDATED_AT = 'date_modified';

    /**
     * @param integer $customer_id
     * @param string $group_name
     * @return CustomerSalesStats
     */

    public static function findOrNew($customer_id, $group_name)
    {
        $obj = self::where('customer_id', $customer_id)->where('group_name', $group_name)->first();
        if (!$obj){
            $obj = new static;
            $obj->customer_id = $customer_id;
            $obj->group_name = $group_name;
        }
        return $obj;
    }

    public function customers()
    {
        return $this->belongsTo(Customer::class, 'customer_id');
    }

}
