<?php

namespace Hilco\Models;

/**
 * Class WebLandingPage_WebSilo
 * @package Hilco\Models
 * @property integer $websilo_id
 * @property integer $weblandingpage_id
 * @property integer $plant_id
 * @method static \Illuminate\Database\Query\Builder bySiloPage($value,$value)
 */
class WebLandingPage_WebSilo extends WebModel {

	protected $table = "WebLandingPage_WebSilo";
    protected $fillable = ['weblandingpage_id', 'websilo_id', 'plant_id'];

    public function plant() {
        return $this->belongsTo(Plant::class, 'plant_id', 'id');
    }

    public function webLandingPage() {
        return $this->belongsTo(WebLandingPage::class, 'weblandingpage_id', 'id');
    }

    public function webSilo() {
        return $this->belongsTo(WebSilo::class, 'websilo_id', 'id');
    }

    public function scopeBySiloPage ($query, $webSiloId, $webLandingPageId) {
        return $query->whereRaw("websilo_id = ? AND weblandingpage_id = ?", [$webSiloId, $webLandingPageId]);
    }
}
