<?php

namespace Hilco\Models;

use Illuminate\Database\Eloquent\Relations\BelongsTo;

/**
 * @property integer $webfamily_id
 * @property integer $webuser_id
 * @property WebFamily $webFamily
 * @property WebUser $webUser
 */
class WebFamily_WebUser extends WebModel {
    protected $table = "WebFamily_WebUser";
    protected $fillable = ['webfamily_id', 'webuser_id'];

    /**
     * @return BelongsTo
     */
    public function webFamily(): BelongsTo {
        return $this->belongsTo(WebFamily::class, "webfamily_id", "id");
    }

    /**
     * @return BelongsTo
     */
    public function webUser(): BelongsTo {
        return $this->belongsTo(WebUser::class, "webuser_id", "id");
    }
}