<?php

namespace Hilco\Models;

use Illuminate\Database\Eloquent\Collection;
use Illuminate\Database\Eloquent\Relations\BelongsTo;
use Illuminate\Database\Eloquent\Relations\HasMany;
use Illuminate\Database\Query\Builder;

/**
 * Hilco\Models\ProductFamily
 *
 * @property mixed $id
 * @property string $product_family_no
 * @property mixed $productcategory_id
 * @property mixed $financialreportgroup_id
 * @property string $product_category
 * @property string $productfamily_description
 * @property string $date_created
 * @property string $date_modified
 * @property string $deleted_at
 * @property-read ProductCategory $productCategory
 * @property-read Collection|Part[] $parts
 * @property-read mixed $id_string
 * @method static Builder|ProductFamily whereId($value)
 * @method static Builder|ProductFamily whereProductFamilyNo($value)
 * @method static Builder|ProductFamily whereProductcategoryId($value)
 * @method static Builder|ProductFamily whereFinancialreportgroupId($value)
 * @method static Builder|ProductFamily whereDateCreated($value)
 * @method static Builder|ProductFamily whereDateModified($value)
 * @method static Builder|ProductFamily whereDeletedAt($value)
 * @mixin \Eloquent
 * @property string $date_uploaded
 * @method static Builder|ProductFamily whereDateUploaded($value)
 */
class ProductFamily extends WebModel {
	protected $table = 'ProductFamilies';

	/**
	 * @deprecated ?????????
	 */
	public function part()
	{
		return $this->belongsTo(Part::class, 'id', 'productfamily_id');
	}

	public function productCategory(): BelongsTo {
	    return $this->belongsTo(ProductCategory::class, 'productcategory_id');
    }

    public function parts(): HasMany {
	    return $this->hasMany(Part::class, 'productfamily_id', 'id');
    }

    public function getProductFamilyNo(): string {
        return $this->product_family_no;
    }

    public function getProductFamilyDesc() {
        return $this->productfamily_description;
    }
}
