<?php

namespace Hilco\Models;


/**
 * Hilco\Models\OrderMiscLine
 *
 * @property mixed $id
 * @property integer $misccharge_id
 * @property float $unit_price
 * @property string $date_created
 * @property string $date_modified
 * @property string $date_uploaded
 * @property string $deleted_at
 * @property-read \Hilco\Models\MiscCharge $miscCharge
 * @property-read mixed $id_string
 * @method static \Illuminate\Database\Query\Builder|\Hilco\Models\OrderMiscLine whereId($value)
 * @method static \Illuminate\Database\Query\Builder|\Hilco\Models\OrderMiscLine whereMiscchargeId($value)
 * @method static \Illuminate\Database\Query\Builder|\Hilco\Models\OrderMiscLine whereUnitPrice($value)
 * @method static \Illuminate\Database\Query\Builder|\Hilco\Models\OrderMiscLine whereDateCreated($value)
 * @method static \Illuminate\Database\Query\Builder|\Hilco\Models\OrderMiscLine whereDateModified($value)
 * @method static \Illuminate\Database\Query\Builder|\Hilco\Models\OrderMiscLine whereDateUploaded($value)
 * @method static \Illuminate\Database\Query\Builder|\Hilco\Models\OrderMiscLine whereDeletedAt($value)
 * @mixin \Eloquent
 * @property mixed $salesorder_id
 * @property integer $line_number
 * @property integer $line_order
 * @property string $line_suborder
 * @method static \Illuminate\Database\Query\Builder|\Hilco\Models\OrderMiscLine whereSalesorderId($value)
 * @method static \Illuminate\Database\Query\Builder|\Hilco\Models\OrderMiscLine whereLineNumber($value)
 * @method static \Illuminate\Database\Query\Builder|\Hilco\Models\OrderMiscLine whereLineOrder($value)
 * @method static \Illuminate\Database\Query\Builder|\Hilco\Models\OrderMiscLine whereLineSuborder($value)
 */
class OrderMiscLine extends UuidModel
{
    protected $table = 'SalesOrderMiscLines';
    
    public function miscCharge() {
        return $this->belongsTo(MiscCharge::class, 'misccharge_id');
    }
}
